//+------------------------------------------------------------------+ 
//|                                             ATRSmoothed_3HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.60"
#property description "  ATRSmoothed         ."
//---     
#property indicator_separate_window
//---    3
#property indicator_buffers 3 
//---     
#property indicator_plots   3
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                        //        
#define INDICATOR_NAME "ATRSmoothed"   //    
#define SIZE 3                         //      CountIndicator  
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_HISTOGRAM
//---     
#property indicator_color1  clrOrange
//---    1  2
#property indicator_width1  2
//---   
#property indicator_label1  "ATRSmoothed 1"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---     
#property indicator_color2  clrMediumOrchid
//---    2  3
#property indicator_width2  3
//---   
#property indicator_label2  "ATRSmoothed 2"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_LINE
//---     
#property indicator_color3  clrSteelBlue
//---    3  5
#property indicator_width3  5
//---   
#property indicator_label3  "ATRSmoothed 3"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame1=PERIOD_M30; //    3 ( )
input ENUM_TIMEFRAMES TimeFrame2=PERIOD_H1;  //    2 ( )
input ENUM_TIMEFRAMES TimeFrame3=PERIOD_H4;  //    1 ( )
input int    ATRPeriod=14;
input Smooth_Method XMA_Method=MODE_JJMA;    //  
input int XLength=5;                         //                       
input int XPhase=15;                         //  
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int                  Shift=0;          //      
//+----------------------------------------------+
//---   ,   
//---      
double Ind1Buffer[];
double Ind2Buffer[];
double Ind3Buffer[];
//---      
int min_rates_total;
//---      
int Ind1_Handle,Ind2_Handle,Ind3_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+
//|                                          |
//+------------------------------------------------------------------+
string GetStringPrice(ENUM_APPLIED_PRICE price)
  {return(StringSubstr(EnumToString(price),6,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame1,TimeFrame2,TimeFrame3)) return(INIT_FAILED);
//---   
   min_rates_total=2;
//---    ATRSmoothed 1
   Ind1_Handle=iCustom(Symbol(),TimeFrame1,INDICATOR_NAME,ATRPeriod,XMA_Method,XLength,XPhase,0);
   if(Ind1_Handle==INVALID_HANDLE)
     {
      Print("      ATRSmoothed 1");
      return(INIT_FAILED);
     }
//---    ATRSmoothed 2
   Ind2_Handle=iCustom(Symbol(),TimeFrame2,INDICATOR_NAME,ATRPeriod,XMA_Method,XLength,XPhase,0);
   if(Ind2_Handle==INVALID_HANDLE)
     {
      Print("      ATRSmoothed 2");
      return(INIT_FAILED);
     }
//---    ATRSmoothed 3
   Ind3_Handle=iCustom(Symbol(),TimeFrame3,INDICATOR_NAME,ATRPeriod,XMA_Method,XLength,XPhase,0);
   if(Ind3_Handle==INVALID_HANDLE)
     {
      Print("      ATRSmoothed 3");
      return(INIT_FAILED);
     }
//---   
   IndInit(0,Ind1Buffer,EMPTY_VALUE,min_rates_total,Shift);
   IndInit(1,Ind2Buffer,EMPTY_VALUE,min_rates_total,Shift);
   IndInit(2,Ind3Buffer,EMPTY_VALUE,min_rates_total,Shift);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",
                     GetStringTimeframe(TimeFrame1)," ,",GetStringTimeframe(TimeFrame2)," ,",GetStringTimeframe(TimeFrame3)," ,",ATRPeriod,")");
//--- 
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind1_Handle)<Bars(Symbol(),TimeFrame1)) return(prev_calculated);
   if(BarsCalculated(Ind2_Handle)<Bars(Symbol(),TimeFrame2)) return(prev_calculated);
   if(BarsCalculated(Ind3_Handle)<Bars(Symbol(),TimeFrame3)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---
   if(!CountIndicator(0,NULL,TimeFrame1,Ind1_Handle,0,Ind1Buffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(1,NULL,TimeFrame2,Ind2_Handle,0,Ind2Buffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(2,NULL,TimeFrame3,Ind3_Handle,0,Ind3Buffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],double Empty_Value,int Draw_Begin,int nShift)
  {
//---      
   SetIndexBuffer(Number,Buffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Draw_Begin);
//---    2    Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//---       
   ArraySetAsSeries(Buffer,true);
  }
//+------------------------------------------------------------------+
//| CountIndicator                                                   |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,             //   CountLine      (  - 0)
                    string   Symb,             //  
                    ENUM_TIMEFRAMES TFrame,    //  
                    int      IndHandle,        //   
                    uint     BuffNumb,         //    
                    double&  IndBuf[],         //   
                    const datetime& iTime[],   //  
                    const int Rates_Total,     //       
                    const int Prev_Calculated, //       
                    const int Min_Rates_Total) //       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1;                    //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      IndBuf[bar]=0.0;
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //---       Arr
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);
         IndBuf[bar]=Arr[0];
        }
      else IndBuf[bar]=IndBuf[bar+1];
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame1, //    1 ( )
                     ENUM_TIMEFRAMES TFrame2, //    2 ( )
                     ENUM_TIMEFRAMES TFrame3) //    3 ( )
  {
//---     
   if(TFrame1<Period() && TFrame1!=PERIOD_CURRENT)
     {
      Print("  1   "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//---
   if(TFrame2<=TFrame1)
     {
      Print("  2   "+IndName+"      1!");
      Print("    !");
      return(RESET);
     }
//---
   if(TFrame3<=TFrame2)
     {
      Print("  3   "+IndName+"      2!");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
