//+---------------------------------------------------------------------+
//|                                         VKW_Bands_Modify_Candle.mq5 | 
//|                                     Copyright  2008, Alksnis Gatis | 
//|                                                   2xpoint@gmail.com | 
//+---------------------------------------------------------------------+
//|          SmoothAlgorithms.mqh |
//|   (): terminal_data_folder\MQL5\Include             |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2008, Alksnis Gatis"
#property link "2xpoint@gmail.com"
#property description " ,    "
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 7 
//----     
#property indicator_plots   3
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_CANDLES
#property indicator_color1   clrRed,clrGray,clrBlue
//----   
#property indicator_label1  "Open;High;Low;Close"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----       DodgerBlue 
#property indicator_color2 clrLimeGreen
//----   -  
#property indicator_style2  STYLE_SOLID
//----     1
#property indicator_width2  1
//----   
#property indicator_label2  "VKW_Bands Upper"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type3   DRAW_LINE
//----       Magenta 
#property indicator_color3 clrMagenta
//----   -  
#property indicator_style3  STYLE_SOLID
//----     1
#property indicator_width3  1
//----   
#property indicator_label3  "VKW_Bands Lower"
//+-----------------------------------+
//|                   |
//+-----------------------------------+
#property indicator_level1 60
#property indicator_level2 40
#property indicator_levelcolor clrMagenta
#property indicator_levelstyle STYLE_DASHDOTDOT
//+-----------------------------------+
//|                  |
//+-----------------------------------+
#define RESET 0                      //        
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint PeriodRSI=7;                               //  
input int StepSizeFast=5;                             //  
input int StepSizeSlow=15;                            //  
input int IShift=0;                                   //       
input uint RPeriod=25;                                //    
input Smooth_Method SmMA_Method=MODE_SMA;             //  
input uint SLength=3;                                 //                      
input int SPhase=100;                                 //  
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int SShift=0;                                   //       
//+-----------------------------------+
//----   ,    
//----      
double ExtOpenBuffer[],ExtHighBuffer[],ExtLowBuffer[],ExtCloseBuffer[],ExtColorBuffer[];
double UpIndBuffer[],DnIndBuffer[];
//----      
int Ind_Handle[4];
//----      
int min_rates_total,min_rates_1;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   min_rates_1=int(PeriodRSI);
   min_rates_1+=int(RPeriod);
   min_rates_total=min_rates_1+GetStartBars(SmMA_Method,SLength,SPhase);
//----    METRO
   Ind_Handle[0]=iCustom(NULL,0,"METRO",PeriodRSI,StepSizeFast,StepSizeSlow,0,PRICE_OPEN);
   if(Ind_Handle[0]==INVALID_HANDLE)
     {
      Print("      METRO["+string(0)+"]!");
      return(INIT_FAILED);
     }
//----
   Ind_Handle[1]=iCustom(NULL,0,"METRO",PeriodRSI,StepSizeFast,StepSizeSlow,0,PRICE_HIGH);
   if(Ind_Handle[1]==INVALID_HANDLE)
     {
      Print("      METRO["+string(1)+"]!");
      return(INIT_FAILED);
     }
//----
   Ind_Handle[2]=iCustom(NULL,0,"METRO",PeriodRSI,StepSizeFast,StepSizeSlow,0,PRICE_LOW);
   if(Ind_Handle[2]==INVALID_HANDLE)
     {
      Print("      METRO["+string(2)+"]!");
      return(INIT_FAILED);
     }
//----
   Ind_Handle[3]=iCustom(NULL,0,"METRO",PeriodRSI,StepSizeFast,StepSizeSlow,0,PRICE_CLOSE);
   if(Ind_Handle[3]==INVALID_HANDLE)
     {
      Print("      METRO["+string(3)+"]!");
      return(INIT_FAILED);
     }
///----      
   SetIndexBuffer(0,ExtOpenBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtHighBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLowBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,ExtCloseBuffer,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(4,ExtColorBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ExtOpenBuffer,true);
   ArraySetAsSeries(ExtHighBuffer,true);
   ArraySetAsSeries(ExtLowBuffer,true);
   ArraySetAsSeries(ExtCloseBuffer,true);
   ArraySetAsSeries(ExtColorBuffer,true);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----     
   PlotIndexSetInteger(0,PLOT_SHIFT,IShift);

//----      
   SetIndexBuffer(5,UpIndBuffer,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,SShift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);
//----          
   ArraySetAsSeries(UpIndBuffer,true);

//----      
   SetIndexBuffer(6,DnIndBuffer,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,SShift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0);
//----          
   ArraySetAsSeries(DnIndBuffer,true);

//----      
   string shortname="VKW_Bands_METRO_Candle";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(Ind_Handle[0])<rates_total
      || BarsCalculated(Ind_Handle[1])<rates_total
      || BarsCalculated(Ind_Handle[2])<rates_total
      || BarsCalculated(Ind_Handle[3])<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//----       
   double d_max,d_min;
//----        
   int limit,to_copy,bar,maxbar;
   maxbar=rates_total-1-min_rates_1;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=maxbar; //      
     }
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+1+int(RPeriod);
//----      
   if(CopyBuffer(Ind_Handle[0],0,0,to_copy,ExtOpenBuffer)<=0) return(RESET);
   if(CopyBuffer(Ind_Handle[1],0,0,to_copy,ExtHighBuffer)<=0) return(RESET);
   if(CopyBuffer(Ind_Handle[2],0,0,to_copy,ExtLowBuffer)<=0) return(RESET);
   if(CopyBuffer(Ind_Handle[3],0,0,to_copy,ExtCloseBuffer)<=0) return(RESET);
//----      
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      double Max=MathMax(ExtOpenBuffer[bar],ExtCloseBuffer[bar]);
      double Min=MathMin(ExtOpenBuffer[bar],ExtCloseBuffer[bar]);
      //----
      ExtHighBuffer[bar]=MathMax(Max,ExtHighBuffer[bar]);
      ExtLowBuffer[bar]=MathMin(Min,ExtLowBuffer[bar]);
      //----
      if(ExtOpenBuffer[bar]<ExtCloseBuffer[bar]) ExtColorBuffer[bar]=2.0;
      else if(ExtOpenBuffer[bar]>ExtCloseBuffer[bar]) ExtColorBuffer[bar]=0.0;
      else ExtColorBuffer[bar]=1.0;
     }
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      d_max=ExtHighBuffer[ArrayMaximum(ExtHighBuffer,bar,RPeriod)];
      d_min=ExtLowBuffer[ArrayMinimum(ExtLowBuffer,bar,RPeriod)];
      UpIndBuffer[bar]=XMA1.XMASeries(maxbar,prev_calculated,rates_total,SmMA_Method,SPhase,SLength,d_max,bar,true);
      DnIndBuffer[bar]=XMA2.XMASeries(maxbar,prev_calculated,rates_total,SmMA_Method,SPhase,SLength,d_min,bar,true);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
