/*
 *         
 * SmoothAlgorithms.mqh
 *   (): MetaTrader\\MQL5\Include
 */
//+------------------------------------------------------------------+
//|                                       ColorJFatlAcceleration.mq5 |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//----     
#property indicator_separate_window 
//----        
#property indicator_buffers 3
//----     
#property indicator_plots   2

//----     
#property indicator_type1   DRAW_LINE
//----       
#property indicator_color1  Gray
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "JFATL Acceleration"

//----     
#property indicator_type2   DRAW_COLOR_ARROW
//----      ,    
#property indicator_color2  Gray,DarkOrchid,Red
//----   -  
#property indicator_style2  STYLE_SOLID
//----     2
#property indicator_width2  2
//----   
#property indicator_label2  "JFATL Acceleration"
//+-----------------------------------+
//|         |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPLE_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_, //PRICE_TRENDFOLLOW0_
   PRICE_TRENDFOLLOW1_  //PRICE_TRENDFOLLOW1_
  };
input int SmLength_=8; //  JMA  Fatl                   
input int SmPhase_=100; //  JMA  Fatl,
                      //   -100 ... +100,
//    ;

input int SpeedPeriod=1;// 
input int AccelerationPeriod=1;// 

input int Smooth=2; //  JMA                    
input int SmPhase=100; //  JMA  ,
                       //   -100 ... +100,
//    ;

input Applied_price_ IPC=PRICE_CLOSE_;// 
/* ,      ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPLE, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */

input int FATLShift=0; //      
//+-----------------------------------+

//----          FATL
int FATLPeriod=39;

//----   ,    
//      
double IndBuffer[];
double ColorBuffer[];
double LineIndBuffer[];

int start,fstart,jfstart,mstart,spstart,FATLSize;
double dPriceShift;
//+------------------------------------------------------------------+
//   iPriceSeries()                                   |
//   CFATL, CJJMA  CMomentum                         |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh>  
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----  
   fstart=FATLPeriod;
   jfstart=fstart+30;
   mstart=jfstart+SpeedPeriod;
   spstart=mstart+30+1;
   start=spstart+AccelerationPeriod;

//----    IndBuffer   
   SetIndexBuffer(0,LineIndBuffer,INDICATOR_DATA);
//----       FATLShift
   PlotIndexSetInteger(0,PLOT_SHIFT,FATLShift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,start);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);

//----    IndBuffer   
   SetIndexBuffer(1,IndBuffer,INDICATOR_DATA);
//----       FATLShift
   PlotIndexSetInteger(1,PLOT_SHIFT,FATLShift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,start);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----    
   PlotIndexSetInteger(1,PLOT_ARROW,159);

//----     ,     
   SetIndexBuffer(2,ColorBuffer,INDICATOR_COLOR_INDEX);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,start);

//----      
   string shortname;
   StringConcatenate(shortname,"JFATL Speed(",SmLength_," ,",SmPhase_," ,",SpeedPeriod,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);

//----    CJJMA   JJMASeries_Cls.mqh
   CJJMA JMA;
//----       
   JMA.JJMALengthCheck("Length_", SmLength_);
   JMA.JJMAPhaseCheck("Phase_", SmPhase_);
   JMA.JJMALengthCheck("SpeedMomPeriod", SpeedPeriod);
   JMA.JJMALengthCheck("Smooth", Smooth);
   JMA.JJMAPhaseCheck("SmPhase", SmPhase);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<start)
      return(0);

//----    
   int first,bar;
   double price,jfatl,fatl,jmom1,jmom2,jfspeed;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
     }
   else first=prev_calculated-1; //      

//----    CFATL, CJJMA  CMomentum   JJMASeries_Cls.mqh
   static CJJMA JMA1,JMA2;
   static CFATL FATL;
   static CMomentum MOM1,MOM2;

//----    
   for(bar=first; bar<rates_total; bar++)
     {
      //----    price
      price=PriceSeries(IPC,bar,open,low,high,close);

      //----    price  FATLSeries()   fatl
      fatl=FATL.FATLSeries(0,prev_calculated,rates_total,price,bar,false);

      //----  fatl  JJMASeries()   jfatl
      jfatl=JMA1.JJMASeries(fstart,prev_calculated,rates_total,0,SmPhase_,SmLength_,fatl,bar,false);

      //----  jfatl  MomentumSeries()   jmom
      jmom1=MOM1.MomentumSeries(jfstart,prev_calculated,rates_total,SpeedPeriod,jfatl,bar,false);

      //----  jmom  JJMASeries()   jfspeed
      jfspeed=JMA2.JJMASeries(mstart,prev_calculated,rates_total,0,SmPhase,Smooth,jmom1,bar,false);

      jmom2=MOM2.MomentumSeries(spstart,prev_calculated,rates_total,AccelerationPeriod,jfspeed,bar,false);

      //----      
      jmom2/=_Point;

      //----  jfspeed   
      IndBuffer[bar]=jmom2;
      LineIndBuffer[bar]=jmom2;
     }

//----        
   if(prev_calculated>rates_total || prev_calculated<=0) first=start;

//----     
   for(bar=first; bar<rates_total; bar++)
     {
      ColorBuffer[bar]=0;
      if(IndBuffer[bar]>IndBuffer[bar-1]) ColorBuffer[bar]=1;
      if(IndBuffer[bar]<IndBuffer[bar-1]) ColorBuffer[bar]=2;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
