//+---------------------------------------------------------------------+ 
//|                                              HistVolatility_HTF.mq5 | 
//|                                  Copyright  2015, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+  
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.60"
//----     
#property indicator_separate_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                               //        
#define INDICATOR_NAME "HistVolatility"       //    
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_HISTOGRAM
//----       
#property indicator_color1 clrGray,clrPurple,clrDarkTurquoise
//----   -  
#property indicator_style1  STYLE_SOLID
//----     3
#property indicator_width1  3
//----   
#property indicator_label1  INDICATOR_NAME
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Scale_ // 
  {
   S1_ = 1,     //1
   S2_,         //2
   S3_          //3
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4; //  
input int Per=21;
input Scale_ Scale=S3_;
input int Trading_Day_In_Year=365;
input int Percent=100;
input double Coeff=1;
input int Shift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double IndBuffer[],ColorIndBuffer[];
//----   
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int Ind_Handle;
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    HistVolatility       ");
      return(INIT_FAILED);
     }
//----   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//----    HistVolatility
   Ind_Handle=iCustom(Symbol_,TimeFrame,"HistVolatility",Per,Scale,Trading_Day_In_Year,Percent,Coeff,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      HistVolatility");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----     
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(IndBuffer,true);
//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,INDICATOR_NAME);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//----    
   double Ind[1],Col[1];
   int limit,bar;
   datetime IndTime[1];
   static uint LastCountBar;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       
//----         
   ArraySetAsSeries(time,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuffer[bar]=EMPTY_VALUE;
      //----       IndTime
      if(CopyTime(Symbol_,TimeFrame,time[bar],1,IndTime)<=0) return(RESET);
      //----
      if(time[bar]>=IndTime[0] && time[bar+1]<IndTime[0])
        {
         LastCountBar=bar;
         //----       Ind
         if(CopyBuffer(Ind_Handle,0,time[bar],1,Ind)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,1,time[bar],1,Col)<=0) return(RESET);
         //----
         IndBuffer[bar]=Ind[0];
         ColorIndBuffer[bar]=Col[0];
        }
      else
        {
         IndBuffer[bar]=IndBuffer[bar+1];
         ColorIndBuffer[bar]=ColorIndBuffer[bar+1];
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
