//+---------------------------------------------------------------------+
//|                                                  LinearMomentum.mq5 |
//|                                 Copyright  2015, Totom Sukopratomo |
//|                                          https://www.mqlmonster.com |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2015, Totom Sukopratomo"
#property link "https://www.mqlmonster.com"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "LinearMomentum"
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method XMA_Method=MODE_EMA; //  
input int XLength=14; //  
input int XPhase=15;  //  
                      //  JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK; // 
input int Shift=0; //      
//+-----------------------------------+
//----   ,    
//----      
double IndBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=GetStartBars(XMA_Method,XLength,XPhase);
//----       
   XMA1.XMALengthCheck("XLength",XLength);
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"LinearMomentum(",XLength,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double distance,dprice,temporary,velocity;
//----        
   int first,bar,dtime,max;
   long vol;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=1; //      
   else first=prev_calculated-1; //      
   max=rates_total-1;
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      if(bar!=max) dtime=int(time[bar]-time[bar-1]);
      else dtime=int(TimeCurrent()-time[bar]);
      dprice=close[bar]-open[bar];
      //----
      if(NormalizeDouble(dprice,8)) distance=dprice/_Point;
      else distance=0.0;
      //----
      if(NormalizeDouble(distance,8) && dtime) velocity=distance/dtime;
      else velocity=0.0;
      //----     
      if(VolumeType==VOLUME_TICK) vol=long(tick_volume[bar]);
      else vol=long(volume[bar]);
      //----
      temporary=double(vol*velocity);
      IndBuffer[bar]=XMA1.XMASeries(1,prev_calculated,rates_total,XMA_Method,XPhase,XLength,temporary,bar,false);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
