//+------------------------------------------------------------------+
//|                                                   ipulsar_v3.mq4 |
//|                              Copyright 2012, 2015  .. |
//|                                                    alextar@bk.ru |
//+------------------------------------------------------------------+
/* iPulsar      Scale(  - ), 
                    High  Low. 
            ,  ""  . 
             : 
            1.    , LevelFilter .  , 
                Scale,    .
            2.    ( ),SignalFilter . 
                ,  "" 
               ,      ,   
             . */
#property   copyright "Copyright 2012, 2015  .."
#property   link      "alextar@bk.ru"
#property   strict
#property   indicator_separate_window  //  
#property   indicator_buffers 2
#property   indicator_color1 Magenta   //  
#property   indicator_width1 2
#property   indicator_color2 Teal
#property   indicator_width2 2
#define     Version  "iPulsar_v3"      // 
#define     Zero     0.00000001
bool        IsHighReported,            //   
            IsLowReported;
int         Hval,Lval,                 //  
            Signals;                   //   
datetime    HT,LT,                     //   
            BarTime;                   //    
double      HP[],LP[],                 // 
            Periods;                   //     
//---  : 
extern bool    SetSignalFilter=true;   //  ?
extern double  LevelFilter    =5,      //  , Scales
SignalFilter   =0;                     //  , Bars/Scales <0
extern int     Scale          =1440,   //   
ScaleDigits=0;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorShortName(Version);        //  
   IndicatorDigits(ScaleDigits);
   SetIndexLabel(0,"High");            //  
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,HP);
   SetIndexLabel(1,"Low");
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1,LP);
   if(Scale<0) Scale=-Scale;           //   
   if(Scale==0) Scale=Period();
   if(ScaleDigits<0) ScaleDigits=-ScaleDigits;
   if(ScaleDigits>Digits()) ScaleDigits=Digits();
   Periods=Scale/Period();             //   
   IsHighReported=false;
   IsLowReported =false;
   HT     =0;
   LT     =0;
   BarTime=0;
   Hval   =0;
   Lval   =0;
   Signals=0;
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   double H,L,HB,LB,dSF,
   dLF=LevelFilter*Periods+0.5;
   bool HD,LD;
   int LF=(int)dLF,                    //  , Bars
   SF,                                 //  , Bars
   i,k,Hbar,Lbar,History=Bars-1;
   if(SignalFilter>-Zero) dSF=SignalFilter+0.5;
   else dSF=-SignalFilter*Periods+0.5;
   SF=(int)dSF;
   if( HT > 0 ) Hbar=iBarShift(NULL,0,HT);
   if( LT > 0 ) Lbar=iBarShift(NULL,0,LT);
   int j=History-IndicatorCounted();   //  
   while(j>=0)
     {
      H=High[j];
      L=Low[j];
      HD=false;                        //   
      LD=false;
      HB=0;                            //     High
      LB=0;                            //     Low
      i=j;
      //---  
      while(i<History)
        {              
         if(HD && LD) break;           //  
         i++;
         k=i-j-1;                      //   
         if(!HD && High[i]-H>Zero)
           {
            HD=true;                   //  High
            //---  
            if(k-LF>-Zero)
              {        
               if(!SetSignalFilter)
                 {
                  HB=k;
                  Signals++;
                 }
               else HB=Signal(j,k,SF,Hbar,Hval,HT,Lbar,Lval,LT);
              }
           }
         if(!LD && L-Low[i]>Zero)
           {
            LD=true;                   //  Low
            //---  
            if(k-LF>-Zero)
              {        
               if(!SetSignalFilter)
                 {
                  LB=k;
                  Signals++;
                 }
               else LB=Signal(j,k,SF,Lbar,Lval,LT,Hbar,Hval,HT);
              }
           }
        }
      //---   
      if(!SetSignalFilter)
        {          
         if(!HD)
           {
            HB=History-j-2;
            Signals++;
           }
         if(!LD)
           {
            LB=History-j-2;
            Signals++;
           }
        }
      //---      :
      HP[j]= NormalizeDouble(HB/Periods,ScaleDigits);
      LP[j]=-NormalizeDouble(LB/Periods,ScaleDigits);
      if(!j)             //    
        {                        
         if(IsNewBar())
           {             //     
            IsHighReported=false;
            IsLowReported =false;
            Comment(Version,":  ",Signals,"   ",Symbol(),", ",Period());
           }
         //---  ,         :
         if(!IsHighReported && HP[j]>Zero)
           {
            IsHighReported=true;
            Alert(Symbol(),", ",Period(),":    ",DoubleToStr(HP[j],ScaleDigits),"*",Scale);
           }
         if(!IsLowReported && LP[j]<-Zero)
           {
            IsLowReported=true;
            Alert(Symbol(),", ",Period(),":     ",DoubleToStr(-LP[j],ScaleDigits),"*",Scale);
           }
        }
      j--;
     }
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double Signal(int       Bar1,          //  
              int       Val1,          //  , Bars
              int       F,             //  , Bars
              int&      Bar0,          //  
              int&      Val0,          //  , Bars
              datetime& T,             //  
              int&      contrBar,      //   
              int&      contrVal,      //   
              datetime &contrT)        //   
  {
   double S=0;                         //   
   int I=Val1-Val0-Bar0+Bar1;          //   
   if(I>= F)                           //   
     {                       
      Signals++;
      S=Val1;                          //   
      Bar0    =Bar1;
      Val0    =Val1;
      T       =Time[Bar1];
      if(Bar1<contrBar)
        {
         contrBar=0;                   //    
         contrVal=0;
         contrT  =0;
        }
     }
   return(S);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool IsNewBar()                        //   
  {                       
   bool NewBar=false;                  //   
   if(BarTime!=Time[0])
     {
      BarTime=Time[0];                 //   
      NewBar =true;                    //   
     }
   return(NewBar);
  }
//+------------------------------------------------------------------+
