//+------------------------------------------------------------------+
//|                                                           FP.mq5 | 
//|                                 Copyright  2006, Nick A. Zhilin |
//|                                              rebus@dialup.etr.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Nick A. Zhilin"
#property link      "rebus@dialup.etr.ru"
#property description "FP channel"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    3
#property indicator_buffers 3 
//----   3  
#property indicator_plots   3
//+--------------------------------------------+ 
//|                          |
//+--------------------------------------------+
#define RESET 0  //        
//+--------------------------------------------+
//|                |
//+--------------------------------------------+
//----     
#property indicator_type1 DRAW_LINE
//----       MediumBlue 
#property indicator_color1 MediumBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "FP"
//+--------------------------------------------+
//|                    |
//+--------------------------------------------+
//----     
#property indicator_type2   DRAW_LINE
#property indicator_type3   DRAW_LINE
//----   
#property indicator_color2  LightSeaGreen
#property indicator_color3  FireBrick
//----  -  
#property indicator_style2 STYLE_SOLID
#property indicator_style3 STYLE_SOLID
//----    2
#property indicator_width2  2
#property indicator_width3  2
//----    
#property indicator_label2  "+FP"
#property indicator_label3  "-FP"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint IPeriod=100;  //  
input int  Shift=0;      //      
//+-----------------------------------+
//----   ,    
//----      
double FPBuffer[],UpFPBuffer[],DnFPBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(IPeriod);
//----      
   SetIndexBuffer(0,FPBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----    ,   
   ArraySetAsSeries(FPBuffer,true);
//----      
   SetIndexBuffer(1,UpFPBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,DnFPBuffer,INDICATOR_DATA);
//----     
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----  ,     
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    ,   
   ArraySetAsSeries(UpFPBuffer,true);
   ArraySetAsSeries(DnFPBuffer,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"FP channel");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----    
   int limit;
   double max,min,pivot,middle;
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else limit=rates_total-prev_calculated; //      
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {      
      max=high[ArrayMaximum(high,bar,IPeriod)];
      min=low [ArrayMinimum(low, bar,IPeriod)];
      pivot=(close[bar+1]+close[bar+2]+close[bar+3])/3;
      middle=(max+min+pivot)/3;     
      FPBuffer[bar]=middle;
      middle*=3;
      UpFPBuffer[bar]=(middle-min)/2;
      DnFPBuffer[bar]=(middle-max)/2;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
