//+------------------------------------------------------------------+
//|                                                  2pbIdeal1MA.mq5 |
//|                             Copyright  2011,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2011, Nikolay Kositsin"
//----    
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//----        
#property indicator_buffers 1
//----     
#property indicator_plots   1
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  clrBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "2pbIdealMA"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Period1 = 10; //  
input uint Period2 = 10; //  
input int MAShift=0; //       
//+----------------------------------------------+ 
//----   ,    
//----      
double ExtLineBuffer[];
//----     
double w1,w2;
//+------------------------------------------------------------------+
//|   Neutron                                            |
//+------------------------------------------------------------------+
double GetIdealMASmooth(double W1_,    //  
                        double W2_,    //  
                        double Series1,//     
                        double Series0,//     
                        double Resalt1)//    

  {
//----
   double Resalt0,dSeries,dSeries2;
   dSeries=Series0-Series1;
   dSeries2=dSeries*dSeries-1.0;
//----
   Resalt0=(W1_ *(Series0-Resalt1)+
            Resalt1+W2_*Resalt1*dSeries2)
   /(1.0+W2_*dSeries2);
//----
   return(Resalt0);
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----  
   w1=1.0/Period1;
   w2=1.0/Period2;
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----      MAShift
   PlotIndexSetInteger(0,PLOT_SHIFT,MAShift);
//----  ,     
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,1);
//----      
   string shortname;
   StringConcatenate(shortname,"2pbIdealMA(",w1,",",w2,")");
//----       
   PlotIndexSetString(0,PLOT_LABEL,shortname);
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,     //       
                const int prev_calculated, //       
                const int begin,           //     
                const double &price[])     //     
  {
//----       
   if(rates_total<1+begin) return(0);
//----    
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=1+begin;  //      
      //----      begin ,      
      if(begin>0)
         PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,begin+1);
      //----
      ExtLineBuffer[begin]=price[begin];
     }
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total; bar++)
      ExtLineBuffer[bar]=GetIdealMASmooth(w1,w2,price[bar-1],price[bar],ExtLineBuffer[bar-1]);
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
