//+------------------------------------------------------------------+
//|                                       channel_breakout_entry.mq5 | 
//|                                       Copyright  2009, darmasdt | 
//|                                          http://indotraders.org/ | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, darmasdt"
#property link "http://indotraders.org/"
#property description ""
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    8
#property indicator_buffers 8 
//----   8  
#property indicator_plots   8
//+--------------------------------------------+
//|                |
//+--------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
#property indicator_type2   DRAW_LINE
#property indicator_type3   DRAW_LINE
#property indicator_type4   DRAW_LINE
#property indicator_type5   DRAW_LINE
#property indicator_type6   DRAW_LINE
#property indicator_type7   DRAW_LINE
#property indicator_type8   DRAW_LINE
//----   
#property indicator_color1 clrDarkGray
#property indicator_color2 clrDarkGray
#property indicator_color3 clrDodgerBlue
#property indicator_color4 clrDodgerBlue
#property indicator_color5 clrTomato
#property indicator_color6 clrTomato
#property indicator_color7 clrLightSkyBlue
#property indicator_color8 clrPlum
//----  -  
#property indicator_style1 STYLE_SOLID
#property indicator_style2 STYLE_SOLID
#property indicator_style3 STYLE_SOLID
#property indicator_style4 STYLE_SOLID
#property indicator_style5 STYLE_SOLID
#property indicator_style6 STYLE_SOLID
#property indicator_style7 STYLE_SOLID
#property indicator_style8 STYLE_SOLID
//----    1
#property indicator_width1  1
#property indicator_width2  1
#property indicator_width3  1
#property indicator_width4  1
#property indicator_width5  1
#property indicator_width6  1
#property indicator_width7  1
#property indicator_width8  1
//----   
#property indicator_label1  "trailing_Up"
#property indicator_label2  "trailing_Dn"
#property indicator_label3  "sys1_Up"
#property indicator_label4  "sys1_Dn"
#property indicator_label5  "failsafe_Up"
#property indicator_label6  "failsafe_Dn"
#property indicator_label7  "Sys 1 Stp"
#property indicator_label8  "Sys 2 Stp"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint Range1=10;
input uint Range2=20;
input uint Range3=55;
input double atr_factor=2;
input int atr_range=14;
input int Shift=0; //      
//+-----------------------------------+
//----   ,    
//----        channel_breakout_entry
double ExtLineBuffer1[],ExtLineBuffer2[],ExtLineBuffer3[],ExtLineBuffer4[];
double ExtLineBuffer5[],ExtLineBuffer6[],ExtLineBuffer7[],ExtLineBuffer8[];
//----      
int ATR_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| channel_breakout_entry indicator initialization function         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(MathMax(MathMax(MathMax(Range1,atr_factor),Range2),Range3));
//----    ATR
   ATR_Handle=iATR(NULL,0,atr_range);
   if(ATR_Handle==INVALID_HANDLE)Print("      ATR");
//----      
   SetIndexBuffer(0,ExtLineBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,ExtLineBuffer2,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLineBuffer3,INDICATOR_DATA);
   SetIndexBuffer(3,ExtLineBuffer4,INDICATOR_DATA);
   SetIndexBuffer(4,ExtLineBuffer5,INDICATOR_DATA);
   SetIndexBuffer(5,ExtLineBuffer6,INDICATOR_DATA);
   SetIndexBuffer(6,ExtLineBuffer7,INDICATOR_DATA);
   SetIndexBuffer(7,ExtLineBuffer8,INDICATOR_DATA);
//----  ,     
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(5,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(6,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(7,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(5,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(6,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(7,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(ExtLineBuffer1,true);
   ArraySetAsSeries(ExtLineBuffer2,true);
   ArraySetAsSeries(ExtLineBuffer3,true);
   ArraySetAsSeries(ExtLineBuffer4,true);
   ArraySetAsSeries(ExtLineBuffer5,true);
   ArraySetAsSeries(ExtLineBuffer6,true);
   ArraySetAsSeries(ExtLineBuffer7,true);
   ArraySetAsSeries(ExtLineBuffer8,true);
//----      
   string shortname;
   StringConcatenate(shortname,"channel_breakout_entry(",Range1,",",Range2,",",Range3,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| channel_breakout_entry iteration function                        | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----       
   double ATR[];
//----    
   int limit,to_copy,bar;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-min_rates_total-2; //      
   else limit=rates_total-prev_calculated; //       
   to_copy=limit+2;
//----       SAR
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//----         
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ExtLineBuffer1[bar]=high[ArrayMaximum(high,bar,Range1)];
      ExtLineBuffer2[bar]=low[ArrayMinimum(low,bar,Range1)];
      ExtLineBuffer3[bar]=high[ArrayMaximum(high,bar,Range2)];
      ExtLineBuffer4[bar]=low[ArrayMinimum(low,bar,Range2)];
      ExtLineBuffer5[bar]=high[ArrayMaximum(high,bar,Range3)];
      ExtLineBuffer6[bar]=low[ArrayMinimum(low,bar,Range3)];
      //----
      if(high[bar+1]<=ExtLineBuffer3[bar+1] && high[bar]>ExtLineBuffer3[bar])
        {
         ExtLineBuffer7[bar]=ExtLineBuffer3[bar]-(ATR[bar+1]*atr_factor);
        }
      if(high[bar+1]<=ExtLineBuffer5[bar+1] && high[bar]>ExtLineBuffer5[bar])
        {
         ExtLineBuffer8[bar]=ExtLineBuffer5[bar]-(ATR[bar+1]*atr_factor);
        }
      if(low[bar+1]>=ExtLineBuffer4[bar+1] && low[bar]<ExtLineBuffer4[bar])
        {
         ExtLineBuffer7[bar]=ExtLineBuffer4[bar]+(ATR[bar+1]*atr_factor);
        }
      if(low[bar+1]>=ExtLineBuffer6[bar+1] && ExtLineBuffer6[bar])
        {
         ExtLineBuffer8[bar]=ExtLineBuffer6[bar]+(ATR[bar+1]*atr_factor);
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
