//+------------------------------------------------------------------+
//|                                                         LRMA.mq5 |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//|     SmoothAlgorithms.mqh                  |
//|    : __\MQL5\Include  |
//+------------------------------------------------------------------+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//----     
#property indicator_chart_window
//----        
#property indicator_buffers 1
//----     
#property indicator_plots   1
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  clrLimeGreen
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int LRMAPeriod=13; // LRMA
input int LRMAShift=0; // LRMA    
input int LRMAPriceShift=0; // LRMA    
//+----------------------------------------------+

//---  
double ExtLineBuffer[];

double dPriceShift;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----         
   string short_name="LRMA";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name+"("+string(LRMAPeriod)+")");
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,LRMAPeriod+1);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----       LRMAShift
   PlotIndexSetInteger(0,PLOT_SHIFT,LRMAShift);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----    
   dPriceShift=_Point*LRMAPriceShift;
//----    Moving_Average   MASeries_Cls.mqh
   CMoving_Average LRMA1;
//----       
   LRMA1.MALengthCheck("LRMAPeriod",LRMAPeriod);
//----
  }
//+------------------------------------------------------------------+
//                              |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh>
#include <IndicatorsAlgorithms.mqh> 
//+------------------------------------------------------------------+ 
//|  Moving Average                                                  |
//+------------------------------------------------------------------+
int OnCalculate
(
 const int rates_total,//       
 const int prev_calculated,//       
 const int begin,//     
 const double &price[]//     
 )
  {
//----       
   if(rates_total<begin+LRMAPeriod)
      return(0);

//----    
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=begin; //      
      for(bar=0; bar<=begin; bar++)
         ExtLineBuffer[bar]=0;
     }
   else first=prev_calculated-1; //      

//----    Moving_Average   LRMASeries_Cls.mqh
   static CLRMA LRMA1;

//----    
   for(bar=first; bar<rates_total; bar++)
     {
      //----   .    LRMASeries.  
      ExtLineBuffer[bar]=LRMA1.LRMASeries(begin,prev_calculated,rates_total,LRMAPeriod,price[bar],bar,false)+dPriceShift;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
