//+------------------------------------------------------------------+
//|                                                   derivative.mq5 |
//|                                      Copyright  2015, Scriptong |
//|                                          http://advancetools.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2015, Scriptong"
#property link      "http://advancetools.net"
//----   
#property version   "1.01"
//----     
#property indicator_separate_window 
//----    1
#property indicator_buffers 1 
//----    
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       Coral 
#property indicator_color1 clrCoral
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "derivative"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum ENUM_PRICE_TYPE // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  // TrendFollow_2 Price 
   PRICE_DEMARK_         // Demark Price
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint  i_slowing = 34;                     // Slowing / 
input ENUM_PRICE_TYPE i_price = PRICE_WEIGHTED; // Applied price /  
//+-----------------------------------+
//----   ,    
//----      
double ExtBuffer[];
//----      
int  min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----     
   min_rates_total=int(i_slowing);
//----      
   SetIndexBuffer(0,ExtBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtBuffer,true);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"derivative");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----    
   int limit,bar;
//----         
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else limit=rates_total-prev_calculated; //      
//----   
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ExtBuffer[bar]=100.0 *(PriceSeries(i_price,bar,open,low,high,close)-PriceSeries(i_price,bar+i_slowing,open,low,high,close))/i_slowing;
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+   
//|                                 |
//+------------------------------------------------------------------+ 
double PriceSeries(uint applied_price,//  
                   uint   bar,        //            
                   const double &Open[],
                   const double &Low[],
                   const double &High[],
                   const double &Close[])
  {
//----
   switch(applied_price)
     {
      //----     ENUM_APPLIED_PRICE
      case  PRICE_CLOSE: return(Close[bar]);
      case  PRICE_OPEN: return(Open [bar]);
      case  PRICE_HIGH: return(High [bar]);
      case  PRICE_LOW: return(Low[bar]);
      case  PRICE_MEDIAN: return((High[bar]+Low[bar])/2.0);
      case  PRICE_TYPICAL: return((Close[bar]+High[bar]+Low[bar])/3.0);
      case  PRICE_WEIGHTED: return((2*Close[bar]+High[bar]+Low[bar])/4.0);
      //----                            
      case  8: return((Open[bar] + Close[bar])/2.0);
      case  9: return((Open[bar] + Close[bar] + High[bar] + Low[bar])/4.0);
      //----                                
      case 10:
        {
         if(Close[bar]>Open[bar])return(High[bar]);
         else
           {
            if(Close[bar]<Open[bar])
               return(Low[bar]);
            else return(Close[bar]);
           }
        }
      //----         
      case 11:
        {
         if(Close[bar]>Open[bar])return((High[bar]+Close[bar])/2.0);
         else
           {
            if(Close[bar]<Open[bar])
               return((Low[bar]+Close[bar])/2.0);
            else return(Close[bar]);
           }
         break;
        }
      //----
      default: return(Close[bar]);
     }
//----
//return(0);
  }
//+------------------------------------------------------------------+
