//+------------------------------------------------------------------+
//|                                                CArrayRing256.mqh |
//|                               Copyright 2012, Konstantin Gruzdev |
//|                            https://login.mql5.com/ru/users/Lizar |
//|                                             Revision 29 Nov 2012 |
//+------------------------------------------------------------------+
#property copyright   "Copyright 2012, Konstantin Gruzdev"
#property link        "https://login.mql5.com/ru/users/Lizar"

//+------------------------------------------------------------------+
//| Class CArrayRing256                                              |
//| Appointment: class to work with tne finite ring buffer           |
//|  of data. The oldest buffer element is replaced by the           |
//|  newest element. This class is a simple version                  |
//|  of ring buffer and has the following features:                  |
//|   - predefined (256 elements) fixed buffer size                  |
//|   - the indexing strictly as in timeseries                       |
//| Link: http://www.mql5.com/ru/code/1379                           |
//+------------------------------------------------------------------+
class CArrayRing256
  {
private:
   double            m_data[UCHAR_MAX+1];             // ring buffer of data
   uchar             m_last_pos;                      // last buffer element position
public:
                     CArrayRing256(): m_last_pos(0)   { Init(EMPTY_VALUE);                         }
   //--- buffer initialization method:
   void              Init(double volue=EMPTY_VALUE)   { ArrayFill(m_data,0,Size(),volue);          }               
   //--- method returns the buffer size:
   int               Size()                           { return (ArraySize(m_data));                }
   //--- method of adding a new element to the buffer:
   void              Add(const double element)        { m_data[++m_last_pos]=element;              } 
   //--- method returns the value of element with the specified index:
   double            At(const uchar index) const      { return(m_data[uchar(m_last_pos-index)]);   }
   double operator   [](const uchar index) const      { return(At(index));                         }
   //--- method returns the value of the last element stored in the buffer:
   double            Last() const                     { return(m_data[m_last_pos]);                } 
   //--- method overwrites the value of the last element in the buffer:
   void              Last(const double element)       { m_data[m_last_pos]=element;                }  
   //--- method overwrites the value of element with the specified index:
   void              Update(const double element,
                            const uchar index=0)      { m_data[uchar(m_last_pos-index)]=element;   }  
  };