//+------------------------------------------------------------------+ 
//|                                                      i_Trend.mq5 | 
//|                                           Copyright  2007,  NNN | 
//|                                                                  | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2007, NNN"
#property link ""
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----    2
#property indicator_buffers 2 
//----    
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrPaleGreen,clrHotPink
//----   
#property indicator_label1  "i_Trend"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET  0 //        
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Mode // 
  {
   Mode_1 = 0,     // 
   Mode_2,         // 
   Mode_3          // 
  };
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Applied_price_ Price_Type=PRICE_CLOSE_;
//----   
input uint MAPeriod=13;
input  ENUM_MA_METHOD   MAType=MODE_EMA;
input ENUM_APPLIED_PRICE   MAPrice=PRICE_CLOSE;
//----  
input uint BBPeriod=20;
input double deviation=2.0;
input ENUM_APPLIED_PRICE   BBPrice=PRICE_CLOSE;
input Mode BBMode=Mode_1;
//+-----------------------------------+
//----      
int  min_rates_total;
//----   ,    
//----      
double ExtABuffer[];
double ExtBBuffer[];
//----      
int MA_Handle,BB_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----     
   min_rates_total=int(MathMax(MAPeriod,BBPeriod));
//----    iMA
   MA_Handle=iMA(NULL,0,MAPeriod,0,MAType,MAPrice);
   if(MA_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//----    iBB
   BB_Handle=iBands(NULL,0,BBPeriod,0,deviation,BBPrice);
   if(BB_Handle==INVALID_HANDLE)
     {
      Print("      iBB");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,ExtABuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtABuffer,true);
//----      
   SetIndexBuffer(1,ExtBBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtBBuffer,true);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"i_Trend");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(MA_Handle)<rates_total
      || BarsCalculated(BB_Handle)<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//----       
   double price,MA[],BB[];
//----   
   int limit,to_copy;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-min_rates_total-1;  //      
   else limit=rates_total-prev_calculated;  //       
//----         
   ArraySetAsSeries(BB,true);
   ArraySetAsSeries(MA,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(close,true);
//----
   to_copy=limit+1;
//----      
   if(CopyBuffer(MA_Handle,0,0,to_copy,MA)<=0) return(RESET);
   if(CopyBuffer(BB_Handle,int(BBMode),0,to_copy,BB)<=0) return(RESET);
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      price=PriceSeries(Price_Type,bar,open,low,high,close);
      ExtABuffer[bar]=price-BB[bar];
      ExtBBuffer[bar]=-(low[bar]+high[bar]-2*MA[bar]);
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+   
//|                                 |
//+------------------------------------------------------------------+ 
double PriceSeries(uint applied_price,//  
                   uint   bar,        //            
                   const double &Open[],
                   const double &Low[],
                   const double &High[],
                   const double &Close[])
  {
//----
   switch(applied_price)
     {
      //----     ENUM_APPLIED_PRICE
      case  PRICE_CLOSE: return(Close[bar]);
      case  PRICE_OPEN: return(Open [bar]);
      case  PRICE_HIGH: return(High [bar]);
      case  PRICE_LOW: return(Low[bar]);
      case  PRICE_MEDIAN: return((High[bar]+Low[bar])/2.0);
      case  PRICE_TYPICAL: return((Close[bar]+High[bar]+Low[bar])/3.0);
      case  PRICE_WEIGHTED: return((2*Close[bar]+High[bar]+Low[bar])/4.0);
      //----                            
      case  8: return((Open[bar] + Close[bar])/2.0);
      case  9: return((Open[bar] + Close[bar] + High[bar] + Low[bar])/4.0);
      //----                                
      case 10:
        {
         if(Close[bar]>Open[bar])return(High[bar]);
         else
           {
            if(Close[bar]<Open[bar])
               return(Low[bar]);
            else return(Close[bar]);
           }
        }
      //----         
      case 11:
        {
         if(Close[bar]>Open[bar])return((High[bar]+Close[bar])/2.0);
         else
           {
            if(Close[bar]<Open[bar])
               return((Low[bar]+Close[bar])/2.0);
            else return(Close[bar]);
           }
         break;
        }
      //----         
      case 12:
        {
         double res=High[bar]+Low[bar]+Close[bar];

         if(Close[bar]<Open[bar]) res=(res+Low[bar])/2;
         if(Close[bar]>Open[bar]) res=(res+High[bar])/2;
         if(Close[bar]==Open[bar]) res=(res+Close[bar])/2;
         return(((res-Low[bar])+(res-High[bar]))/2);
        }
      //----
      default: return(Close[bar]);
     }
//----
//return(0);
  }
//+------------------------------------------------------------------+
