//+------------------------------------------------------------------+ 
//|                                                  Gaus_MA_HTF.mq5 | 
//|                             Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.60"
//----     
#property indicator_chart_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
#define INDICATOR_NAME "Gaus_MA" //    
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_COLOR_LINE
//----     
#property indicator_color1  clrGray,clrTeal,clrCrimson
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  4
#property indicator_width1  4
//----   
#property indicator_label1  INDICATOR_NAME
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_,  //PRICE_TRENDFOLLOW0_
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4; //  
input uint      period=10;      //   
input double    N_=2;           //  
input double    A=-0.001;       //   
input bool      Vol=false;      //   
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK; // 
input Applied_price_ Applied_Price=PRICE_CLOSE_;  //  
input int Shift=0; //      
input int PriceShift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double IndBuffer[],ColorIndBuffer[];
//----   
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int Gaus_MA_Handle;
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    Gaus_MA       ");
      return(INIT_FAILED);
     }
//----  
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//----    Gaus_MA
   Gaus_MA_Handle=iCustom(Symbol_,TimeFrame,"Gaus_MA",period,N_,A,Vol,VolumeType,Applied_Price,0,PriceShift);
   if(Gaus_MA_Handle==INVALID_HANDLE)
     {
      Print("      Gaus_MA");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,108);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----       
   ArraySetAsSeries(IndBuffer,true);
//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,INDICATOR_NAME);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Gaus_MA_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//----    
   double Gaus_MA[1],Col[1];
   int limit,bar;
   datetime Gaus_MATime[1];
   static double LastGaus_MA=0.0;
   static uint LastCountBar;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       
//----         
   ArraySetAsSeries(time,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuffer[bar]=0.0;
      //----       Gaus_MATime
      if(CopyTime(Symbol_,TimeFrame,time[bar],1,Gaus_MATime)<=0) return(RESET);
      //----     
      if(time[bar]>=Gaus_MATime[0] && time[bar+1]<Gaus_MATime[0])
        {
         LastCountBar=bar;
         //----      
         if(CopyBuffer(Gaus_MA_Handle,0,time[bar],1,Gaus_MA)<=0) return(RESET);
         if(CopyBuffer(Gaus_MA_Handle,1,time[bar],1,Col)<=0) return(RESET);
         //----
         IndBuffer[bar]=Gaus_MA[0];
         ColorIndBuffer[bar]=Col[0];
        }
      else
        {
         IndBuffer[bar]=IndBuffer[bar+1];
         ColorIndBuffer[bar]=ColorIndBuffer[bar+1];
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
