//+------------------------------------------------------------------+
//|                                                    BB 3sigma.mq5 |
//|                                     Copyright 2010, Young.K. Han |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright   "2010, Young. K. Han."
#property link        "http://www.mql5.com"
#property description "BB 3sigma based on Bollinger Bands"
#include <MovingAverages.mqh>
//---
#property indicator_chart_window
#property indicator_buffers 8
#property indicator_plots   7

#property indicator_type1   DRAW_LINE
#property indicator_color1  Blue
#property indicator_type2   DRAW_LINE
#property indicator_color2  Red
#property indicator_type3   DRAW_LINE
#property indicator_color3  LightSeaGreen
#property indicator_type4   DRAW_LINE
#property indicator_color4  Orange
#property indicator_width4  2
#property indicator_type5   DRAW_LINE
#property indicator_color5  LightSeaGreen
#property indicator_type6   DRAW_LINE
#property indicator_color6  Red
#property indicator_type7   DRAW_LINE
#property indicator_color7  Blue

#property indicator_label1  "Bands sigma3"
#property indicator_label2  "Bands sigma2"
#property indicator_label3  "Bands sigma1"
#property indicator_label4  "Bands middle"
#property indicator_label5  "Bands sigma1"
#property indicator_label6  "Bands sigma2"
#property indicator_label7  "Bands sigma3"

//--- input parametrs
input int     InpBandsPeriod=20;       // Period
input int     InpBandsShift=0;         // Shift
input string  Dev="Deviation(0.5~1.0)*1 *2 *3";
input double  InpBandsDeviations=1.0;  // Deviation
//--- global variables
int           ExtBandsPeriod,ExtBandsShift;
double        ExtBandsDeviations;
int           ExtPlotBegin=0;
//---- indicator buffer
double        ExtMLBuffer[];
double        ExtTLBuffer3[],ExtTLBuffer2[],ExtTLBuffer1[];
double        ExtBLBuffer1[],ExtBLBuffer2[],ExtBLBuffer3[];
double        ExtStdDevBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//--- check for input values
   if(InpBandsPeriod<2)
     {
      ExtBandsPeriod=20;
      printf("Incorrect value for input variable InpBandsPeriod=%d. Indicator will use value=%d for calculations.",InpBandsPeriod,ExtBandsPeriod);
     }
   else ExtBandsPeriod=InpBandsPeriod;
   if(InpBandsShift<0)
     {
      ExtBandsShift=0;
      printf("Incorrect value for input variable InpBandsShift=%d. Indicator will use value=%d for calculations.",InpBandsShift,ExtBandsShift);
     }
   else
      ExtBandsShift=InpBandsShift;
   if(InpBandsDeviations==0.0)
     {
      ExtBandsDeviations=2.0;
      printf("Incorrect value for input variable InpBandsDeviations=%f. Indicator will use value=%f for calculations.",InpBandsDeviations,ExtBandsDeviations);
     }
   else ExtBandsDeviations=InpBandsDeviations;
//--- define buffers
   SetIndexBuffer(0,ExtTLBuffer3);
   SetIndexBuffer(1,ExtTLBuffer2);
   SetIndexBuffer(2,ExtTLBuffer1);
   SetIndexBuffer(3,ExtMLBuffer);
   SetIndexBuffer(4,ExtBLBuffer1);
   SetIndexBuffer(5,ExtBLBuffer2);
   SetIndexBuffer(6,ExtBLBuffer3);
   SetIndexBuffer(7,ExtStdDevBuffer,INDICATOR_CALCULATIONS);
//--- set index labels
   PlotIndexSetString(0,PLOT_LABEL,"Bands("+string(ExtBandsPeriod)+") Upper3");
   PlotIndexSetString(1,PLOT_LABEL,"Bands("+string(ExtBandsPeriod)+") Upper2");
   PlotIndexSetString(2,PLOT_LABEL,"Bands("+string(ExtBandsPeriod)+") Upper1");
   PlotIndexSetString(3,PLOT_LABEL,"Bands("+string(ExtBandsPeriod)+") Middle");
   PlotIndexSetString(4,PLOT_LABEL,"Bands("+string(ExtBandsPeriod)+") Lower1");
   PlotIndexSetString(5,PLOT_LABEL,"Bands("+string(ExtBandsPeriod)+") Lower2");
   PlotIndexSetString(6,PLOT_LABEL,"Bands("+string(ExtBandsPeriod)+") Lower3");

//--- indicator name
   IndicatorSetString(INDICATOR_SHORTNAME,"BB 3sigma");
//--- indexes draw begin settings
   ExtPlotBegin=ExtBandsPeriod-1;
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,ExtBandsPeriod);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,ExtBandsPeriod);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,ExtBandsPeriod);
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,ExtBandsPeriod);
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,ExtBandsPeriod);
   PlotIndexSetInteger(5,PLOT_DRAW_BEGIN,ExtBandsPeriod);
   PlotIndexSetInteger(6,PLOT_DRAW_BEGIN,ExtBandsPeriod);

//--- indexes shift settings
   PlotIndexSetInteger(0,PLOT_SHIFT,ExtBandsShift);
   PlotIndexSetInteger(1,PLOT_SHIFT,ExtBandsShift);
   PlotIndexSetInteger(2,PLOT_SHIFT,ExtBandsShift);
   PlotIndexSetInteger(3,PLOT_SHIFT,ExtBandsShift);
   PlotIndexSetInteger(4,PLOT_SHIFT,ExtBandsShift);
   PlotIndexSetInteger(5,PLOT_SHIFT,ExtBandsShift);
   PlotIndexSetInteger(6,PLOT_SHIFT,ExtBandsShift);

//--- number of digits of indicator value
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---- OnInit done
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
//--- variables
   int pos;
//--- indexes draw begin settings, when we've recieved previous begin
   if(ExtPlotBegin!=ExtBandsPeriod+begin)
     {
      ExtPlotBegin=ExtBandsPeriod+begin;
      PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,ExtPlotBegin);
      PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,ExtPlotBegin);
      PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,ExtPlotBegin);
      PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,ExtPlotBegin);
      PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,ExtPlotBegin);
      PlotIndexSetInteger(5,PLOT_DRAW_BEGIN,ExtPlotBegin);
      PlotIndexSetInteger(6,PLOT_DRAW_BEGIN,ExtPlotBegin);

     }
//--- check for bars count
   if(rates_total<ExtPlotBegin)
     {
      return(0);
     }
//--- starting calculation
   if(prev_calculated>1) pos=prev_calculated-1;
   else pos=0;
//--- main cycle
   for(int i=pos;i<rates_total;i++)
     {
      //--- middle line
      ExtMLBuffer[i]=SimpleMA(i,ExtBandsPeriod,price);
      //--- calculate and write down StdDev
      ExtStdDevBuffer[i]=StdDev_Func(i,price,ExtMLBuffer,ExtBandsPeriod);
      //--- upper line
      ExtTLBuffer3[i]=ExtMLBuffer[i]+3*ExtBandsDeviations*ExtStdDevBuffer[i];
      ExtTLBuffer2[i]=ExtMLBuffer[i]+2*ExtBandsDeviations*ExtStdDevBuffer[i];
      ExtTLBuffer1[i]=ExtMLBuffer[i]+1*ExtBandsDeviations*ExtStdDevBuffer[i];
      //--- lower line
      ExtBLBuffer1[i]=ExtMLBuffer[i]-1*ExtBandsDeviations*ExtStdDevBuffer[i];
      ExtBLBuffer2[i]=ExtMLBuffer[i]-2*ExtBandsDeviations*ExtStdDevBuffer[i];
      ExtBLBuffer3[i]=ExtMLBuffer[i]-3*ExtBandsDeviations*ExtStdDevBuffer[i];
      //---
     }
//--- OnCalculate done. Return new prev_calculated.
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| Calculate Standard Deviation                                     |
//+------------------------------------------------------------------+
double StdDev_Func(int position,const double &price[],const double &MAprice[],int period)
  {
//--- variables
   double StdDev_dTmp=0.0;
//--- check for position
   if(position<period) return(StdDev_dTmp);
//--- calcualte StdDev
   for(int i=0;i<period;i++) StdDev_dTmp+=MathPow(price[position-i]-MAprice[position],2);
   StdDev_dTmp=MathSqrt(StdDev_dTmp/period);
//--- return calculated value
   return(StdDev_dTmp);
  }
//+------------------------------------------------------------------+
