//+------------------------------------------------------------------+
//|                                           Test_ATR_OnArrayRB.mq5 |
//|                               Copyright 2012, Konstantin Gruzdev |
//|                            https://login.mql5.com/ru/users/Lizar |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, Konstantin Gruzdev"
#property link      "https://login.mql5.com/ru/users/Lizar"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_width1  1

//--- input parameters
input int            MAPeriod = 14;
input ENUM_MA_METHOD MAMethod = MODE_SMA;
//--- indicator buffers
double         ATR_Buffer[];
//--- class with the ATR indicator calculation methods
#include <IncOnRingBuffer\CATROnRingBuffer.mqh>
CATROnRingBuffer atr;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- initialization of the ATR
   if(!atr.Init(MAPeriod,MAMethod)) return(INIT_FAILED);
//--- indicator setting
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//--- indicator buffers mapping
   SetIndexBuffer(0,ATR_Buffer,INDICATOR_DATA);
   PlotIndexSetString(0,PLOT_LABEL,atr.Name());
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime& time[],
                const double& open[],
                const double& high[],
                const double& low[],
                const double& close[],
                const long& tick_volume[],
                const long& volume[],
                const int& spread[])
  {
//--- indicator calculation, based on the price timeseries
   atr.MainOnArray(rates_total,prev_calculated,high,low,close);
//--- first calculation:
   int start=0;
   if(prev_calculated==0)
     {
      start=rates_total-atr.Size()+1;
      PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,start);
      ArrayInitialize(ATR_Buffer,EMPTY_VALUE);
     }
//--- number of bars was changed:
   else start=prev_calculated-1;     
//--- use the values ??of the ring buffe:     
   for(int i=start;i<rates_total;i++)
      ATR_Buffer[i]=atr[rates_total-1-i];
//--- return value of prev_calculated for next call:
   return(rates_total);
  }
//+------------------------------------------------------------------+