//+------------------------------------------------------------------+
//|                                           ColorTrend_CF_Sign.mq5 |
//|                                         CF = Continuation Factor |
//|               Converted by and Copyright: Ronald Verwer/ROVERCOM |
//|                                                         27/04/06 |
//+------------------------------------------------------------------+
//----  
#property copyright "Converted by and Copyright: Ronald Verwer/ROVERCOM"
#property link ""
//----   
#property version   "1.01"
//----     
#property indicator_chart_window
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        DarkOrange 
#property indicator_color1  clrDarkOrange
//---    1  1 
#property indicator_width1  1
//---    
#property indicator_label1  "Trend_CF Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        Aqua 
#property indicator_color2  clrAqua
//---    2  1
#property indicator_width2  1
//---    
#property indicator_label2 "Trend_CF Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Period_=30;
input int Shift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double SellBuffer[],BuyBuffer[];
//----
int ATR_Handle;
int Count[];
//----      
int min_rates_total;
//----      
double x_p[],x_n[],y_p[],y_n[];
//+------------------------------------------------------------------+
//|               |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[]//        
                          )
  {
//----
   int numb;
   static int count=1;
   count--;
   if(count<0) count=int(Period_)-1;
//----
   for(int iii=0; iii<int(Period_); iii++)
     {
      numb=iii+count;
      if(numb>int(Period_)-1) numb-=int(Period_);
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----    
   int ATR_Period=15;
//----    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----  
   min_rates_total=int(MathMax(Period_,ATR_Period));
//----        
   ArrayResize(x_p,Period_);
   ArrayResize(x_n,Period_);
   ArrayResize(y_p,Period_);
   ArrayResize(y_n,Period_);
   ArrayResize(Count,Period_);
//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,124);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,124);
//----    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----      
   string shortname;
   StringConcatenate(shortname,"ColorTrend_CF_Sign(",Period_,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   int first,bar,bar0,bar1,barq;
   double chp,chn,cffp,cffn,dprice,Upper,Lower,ATR[1];
   static double Upper1,Lower1;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=1; //      
     }
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      dprice=close[bar]-close[bar-1];
      //----
      bar0=Count[0];
      bar1=Count[1];
      //----
      if(dprice>0)
        {
         x_p[bar0]=dprice;
         y_p[bar0]=x_p[bar0]+y_p[bar1];
         x_n[bar0]=0;
         y_n[bar0]=0;
        }
      else
        {
         x_n[bar0]=-dprice;
         y_n[bar0]=x_n[bar0]+y_n[bar1];
         x_p[bar0]=0;
         y_p[bar0]=0;
        }
      //----
      if(bar<min_rates_total)
        {
         if(bar<rates_total-1) Recount_ArrayZeroPos(Count);
         continue;
        }
      //----
      chp=0;
      chn=0;
      cffp=0;
      cffn=0;
      //----
      for(int q=int(Period_)-1; q>=0; q--)
        {
         barq=Count[q];
         //----
         chp+=x_p[barq];
         chn+=x_n[barq];
         cffp+=y_p[barq];
         cffn+=y_n[barq];
        }
      //----
      Upper=(chp-cffn)/_Point;
      Lower=(chn-cffp)/_Point;
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      if(Upper1<=Lower1 && Upper>Lower)
        {
         //---       ATR[]
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
         BuyBuffer[bar]=low[bar]-ATR[0]*3/8;
        }
      //---
      if(Upper1>=Lower1 && Upper<Lower)
        {
         //---       ATR[]
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
         SellBuffer[bar]=high[bar]+ATR[0]*3/8;
        }
      //----
      if(bar<rates_total-1)
        {
         Recount_ArrayZeroPos(Count);
         Upper1=Upper;
         Lower1=Lower;
        }
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
