//+------------------------------------------------------------------+
//|                                              ColorLeManTrend.mq5 |
//|                                         Copyright  2009, LeMan. | 
//|                                                 b-market@mail.ru | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2009, LeMan."
//----    
#property link "b-market@mail.ru"
//----   
#property version   "1.01"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 4
//----    
#property indicator_plots   3
//+----------------------------------------------+
//|                     |
//+----------------------------------------------+
//----        
#property indicator_type1   DRAW_FILLING
//----           
#property indicator_color1  clrTeal, clrMagenta
//----   
#property indicator_label1 "LeManTrend"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        BlueViolet 
#property indicator_color2  clrBlueViolet
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  1
#property indicator_width2  1
//----    
#property indicator_label2  "LeManTrend Bulls"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----        BlueViolet 
#property indicator_color3  clrBlueViolet
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  1
#property indicator_width3  1
//----    
#property indicator_label3  "LeManTrend Bears"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int Min       = 13;
input int Midle     = 21;
input int Max       = 34;
input int PeriodEMA=3; //   
//+----------------------------------------------+
//----   ,    
//----      
double BullsBuffer[];
double BearsBuffer[];
double BullsBuffer_[];
double BearsBuffer_[];
//----      
int min_rates_total,start;
//+------------------------------------------------------------------+
//   CMoving_Average                                   | 
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh> 
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   start=MathMax(MathMax(Min,Midle),Max);
   min_rates_total=start+PeriodEMA;
//----    BullsBuffer   
   SetIndexBuffer(0,BullsBuffer,INDICATOR_DATA);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----       
   ArraySetAsSeries(BullsBuffer,true);
//----
//----    BearsBuffer   
   SetIndexBuffer(1,BearsBuffer,INDICATOR_DATA);
//----       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----       
   ArraySetAsSeries(BearsBuffer,true);
//----
//----    BullsBuffer   
   SetIndexBuffer(2,BullsBuffer_,INDICATOR_DATA);
//----       1  min_rates_total
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----       
   ArraySetAsSeries(BullsBuffer_,true);
//----
//----    BearsBuffer   
   SetIndexBuffer(3,BearsBuffer_,INDICATOR_DATA);
//----       2  min_rates_total
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----       
   ArraySetAsSeries(BearsBuffer_,true);
//----
//----      
   string shortname;
   StringConcatenate(shortname,"LeManTrend(",Min,", ",Midle,", ",Max,", ",PeriodEMA,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----    
   int limit,bar,maxbar;
   double High,Low,HH,LL,Bulls,Bears;
//----    maxbar   MASeries()
   maxbar=rates_total-1-start;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=maxbar; //      
   else limit=rates_total-prev_calculated; //      
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//----    CMoving_Average   SmoothAlgorithms.mqh
   static CMoving_Average BULLS,BEARS;
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      High=0.0;
      High+=high[ArrayMaximum(high,bar+1,Min)];
      High+=high[ArrayMaximum(high,bar+1,Midle)];
      High+=high[ArrayMaximum(high,bar+1,Max)];
      HH=3*high[bar]-High;
      //----
      Low=0.0;
      Low+=low[ArrayMinimum(low,bar+1,Min)];
      Low+=low[ArrayMinimum(low,bar+1,Midle)];
      Low+=low[ArrayMinimum(low,bar+1,Max)];
      LL=Low-3*low[bar];
      //----
      Bulls=BULLS.MASeries(maxbar,prev_calculated,rates_total,PeriodEMA,MODE_EMA,HH,bar,true);
      Bears=BEARS.MASeries(maxbar,prev_calculated,rates_total,PeriodEMA,MODE_EMA,LL,bar,true);
      //----
      BullsBuffer[bar]=Bulls;
      BearsBuffer[bar]=Bears;
      //----
      BullsBuffer_[bar]=Bulls;
      BearsBuffer_[bar]=Bears;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
