//+---------------------------------------------------------------------+
//|                                                 ColorJVariation.mq5 | 
//|                                            Copyright  2010, LeMan. |
//|                                                    b-market@mail.ru |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2010, LeMan."
#property link      "b-market@mail.ru"
//----   
#property version   "1.11"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_LINE
//----      
#property indicator_color1 clrGray,clrLime,clrRed
//----   -  
#property indicator_style1 STYLE_SOLID
//----     4
#property indicator_width1  2
//----   
#property indicator_label1  "JVariation"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_SOLID
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int Period_=12;  //  
input ENUM_MA_METHOD MA_Method_=MODE_SMA; //    
input int JLength_=3;  //  JMA                    
input int JPhase_=100; //  JMA 
                       //    -100 ... +100,
                       //     
input int Shift=0; //      
//+----------------------------------------------+
//----  
double LineBuffer[],ColorLineBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//|   Moving_Average                                   |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh> 
//+------------------------------------------------------------------+   
//| Variation indicator initialization function                      | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(3*Period_+30+1);
//----      
   SetIndexBuffer(0,LineBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"JVariation");
//----     ,     
   SetIndexBuffer(1,ColorLineBuffer,INDICATOR_COLOR_INDEX);
//----      
   string shortname;
   StringConcatenate(shortname,"JVariation( Period_ = ",Period_,", MA_Method_ = ",MA_Method_,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| Variation iteration function                                     | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const int begin,          //     
                const double &price[])    //     
  {
//----       
   if(rates_total<min_rates_total+begin) return(0);
//----   
   int first1,first2=0,bar;
//----       
   double ma1,ma2,ma3,jma3;
//----   
   static int start1,start2,start3,start4;
//----     OnCalculate()
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      first1=begin; //      
      //----     
      start1=begin;
      //----
      if(MA_Method_!=MODE_EMA)
        {
         start2 = start1 + Period_;
         start3 = start2 + Period_;
         start4 = start3 + Period_;
         first2 = start4 + 30 + 2;
        }
      else
        {
         start2 = start1 + 30;
         start3 = start2 + 30;
         start4 = start3 + 30;
         first2 = start4 + 30 + 2;
        }
      //---      begin ,      
      if(begin>0) PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,first2);
     }
   else
     {
      first1=prev_calculated-1; //      
      first2=first1;
     }
//----    Moving_Average   SmoothAlgorithms.mqh
   static CMoving_Average MA1,MA2,MA3;
//----    JJMA   SmoothAlgorithms.mqh
   static CJJMA JMA;
//----    
   for(bar=first1; bar<rates_total; bar++)
     {
      //----    MASeries
      ma1 = MA1.MASeries(start1, prev_calculated, rates_total, Period_, MA_Method_, price[bar], bar, false);
      ma2 = MA2.MASeries(start2, prev_calculated, rates_total, Period_, MA_Method_, price[bar]-ma1, bar, false);
      ma3 = MA3.MASeries(start3, prev_calculated, rates_total, Period_, MA_Method_, price[bar]-ma2-ma1, bar, false);
      //----    JJMASeries
      //----  Phase  Length      (Din = 0) 
      jma3=JMA.JJMASeries(start4,prev_calculated,rates_total,0,JPhase_,JLength_,ma3,bar,false);
      //----
      LineBuffer[bar]=jma3;
     }
//----     
   for(bar=first2; bar<rates_total; bar++)
     {
      ColorLineBuffer[bar]=0;
      if(LineBuffer[bar]>LineBuffer[bar-1]) ColorLineBuffer[bar]=1;
      if(LineBuffer[bar]<LineBuffer[bar-1]) ColorLineBuffer[bar]=2;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
