//+------------------------------------------------------------------+
//|                                                      Gaps_cb.mq5 |
//|                                                         Tapochun |
//|                         https://login.mql5.com/ru/users/tapochun |
//+------------------------------------------------------------------+
#property copyright "Tapochun"
#property link      "https://login.mql5.com/ru/users/tapochun"
#property version   "1.00"
#property indicator_separate_window
#property indicator_minimum 0
//---
#property indicator_plots 1
#property indicator_buffers 2
//---
#property indicator_type1 DRAW_COLOR_HISTOGRAM
#property indicator_color1 clrLime, clrRed, clrGray
//+------------------------------------------------------------------+
//|  															|
//+------------------------------------------------------------------+
double bufValue[];            //   
double bufValueClr[];         //   
//+------------------------------------------------------------------+
//|  																|
//+------------------------------------------------------------------+
input int inpBigGap=0;      //    ()
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---   
   SetIndexBuffer(0,bufValue);
   SetIndexBuffer(1,bufValueClr,INDICATOR_COLOR_INDEX);
//---    
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---
   if(inpBigGap>0) //    
     {
      //---      
      IndicatorSetInteger(INDICATOR_LEVELS,1);
      IndicatorSetDouble(INDICATOR_LEVELVALUE,0,inpBigGap);
      IndicatorSetString(INDICATOR_LEVELTEXT,0,"Big Gap");
     }
//---   / 
   IndicatorSetString(INDICATOR_SHORTNAME,"Gap");
//---
   return( INIT_SUCCEEDED );
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---    - 
   if( rates_total <= 0 ) return( 0 );

   if(prev_calculated!=0) //    
     {
      if(rates_total>prev_calculated) //    
        {
         //---      
         Calculation(rates_total-1,rates_total,inpBigGap,open,close);
        }
     }
   else                   //   
     {
      //---    
      Calculation(1,rates_total,inpBigGap,open,close);
     }
//---
   return( rates_total );
  }
//+------------------------------------------------------------------+
//|  																	|
//+------------------------------------------------------------------+
void Calculation(const int first,       //    
                 const int rates_total, //      
                 const int bigGap,      //   
                 const double &open[],  //    
                 const double &close[]  //    
                 )
  {
   int gap;                                 //  
   for( int i = 1; i < rates_total; i++ )   //    
     {
      gap=int(MathRound(MathAbs(( open[i]-close[i-1])/_Point)));   //  , 
      bufValue[i]=gap;                  //    
      if(gap>=bigGap)                   //      
        {                               //  
         if( open[ i ] > close[ i-1 ] ) //   
            bufValueClr[i]=1;           //  - 
         else                           //  
         bufValueClr[i]=0;              //  - 
        }
      else bufValueClr[i]=2;            //      -    
     }
  }
//+------------------------------------------------------------------+
