//+------------------------------------------------------------------+
//|                                                    DailySize.mq5 |
//|                                                         Tapochun |
//|                         https://login.mql5.com/ru/users/tapochun |
//+------------------------------------------------------------------+
#property copyright "Tapochun"
#property link      "https://login.mql5.com/ru/users/tapochun"
#property version   "1.00"
#property indicator_separate_window
#property indicator_minimum 0
#property indicator_plots 1
#property indicator_buffers 1
//---
#property indicator_type1 DRAW_HISTOGRAM
#property indicator_color1 clrRed
#property indicator_label1 "DailySize"
//+------------------------------------------------------------------+
//|  															|
//+------------------------------------------------------------------+
double bufRange[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   bool answer=CheckTimeframe();
   if( !answer ) return( INIT_PARAMETERS_INCORRECT );
//---    
   SetIndexBuffer(0,bufRange);
//---    
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---     
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---
   return( INIT_SUCCEEDED );
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---     - 
   if( rates_total <= 0 ) return( 0 );
//---
   static int dNum;             //   
   static double dHigh = 0.0;   //   
   static double dLow = DBL_MAX;//   
//---
   if(prev_calculated!=0) //    
     {
      //---     
      Calculation(rates_total-1,dNum,dHigh,dLow,rates_total,time,high,low);
     }
   else                   //    
     {
      //---     
      ArrayInitialize(bufRange,0.0);
      //---       
      int firstBar = GetFirstBar( time, rates_total, dNum );
      if( firstBar == 0 ) return( 0 );
      //---     firstBar
      Calculation(firstBar,dNum,dHigh,dLow,rates_total,time,high,low);
     }
//---
   return( rates_total );
  }
//+------------------------------------------------------------------+
//|    											|
//+------------------------------------------------------------------+
bool CheckTimeframe()
  {
   if(_Period>PERIOD_D1) //     1
     {
      Print(__FUNCTION__,":        D1.  !");
      return(false);     //   
     }
   else return(true);    //    -  
  }
//+------------------------------------------------------------------+
//|       					|
//+------------------------------------------------------------------+
int GetFirstBar(const datetime &time[], //       
                const int rates_total,  //   
                int &dayNum)            //    (out)
  {
   int prev = GetDayNumber(time[ 0 ] ); //     
   int curr;                            //     
   for(int i=1; i<rates_total; i++)     //    
     {
      curr=GetDayNumber(time[i]);       //      
      if(curr==prev) continue;          //    -   . 
      else                              //    
        {
         dayNum = curr;                 //     
         return(i );                    //      
        }
     }
//---
   Print(__FUNCTION__,":   ..");
   return(0);                           //  0
  }
//+------------------------------------------------------------------+
//|     											|
//+------------------------------------------------------------------+
int GetDayNumber(const datetime time) //  
  {
   MqlDateTime tStr;                  //  
   TimeToStruct( time,tStr );         //   
   return(tStr.day);                  //    
  }
//+------------------------------------------------------------------+
//|   													|
//+------------------------------------------------------------------+
void Calculation(const int firstBar,     //     
                 int &dNum,              //    (out)
                 double &dHigh,          //    (out)
                 double &dLow,           //    (out)
                 const int rates_total,  //   
                 const datetime &time[], //     
                 const double &high[],   //    
                 const double &low[]     //    
                 )
  {
   int iNum;                                 //    i 
   for(int i = firstBar; i<rates_total; i++) //   
     {
      iNum = GetDayNumber( time[ i ] );      //     i 
      if( dNum != iNum )                     //    
        {
         //---   
         dNum = iNum;                        //     
         dHigh = high[ i ];                  //   i 
         dLow= low[ i ];                     //   i 
        }
      else                                   //    
        {
         //---    / 
         if(high[i]>dHigh)                   //    i   
            dHigh=high[i];                   //      
         //---
         if(low[i]<dLow)                     //    i   
            dLow=low[i];                     //      
        }
      //---    -      
      bufRange[i]=MathRound(( dHigh-dLow)/_Point);
     }
  }
//+------------------------------------------------------------------+
