//+------------------------------------------------------------------+
//|                                                 CGOscillator.mq5 |
//|                                                                  |
//| CG Oscillator                                                    |
//|                                                                  |
//| Algorithm taken from book                                        |
//|     "Cybernetics Analysis for Stock and Futures"                 |
//| by John F. Ehlers                                                |
//|                                                                  |
//|                                              contact@mqlsoft.com |
//|                                          http://www.mqlsoft.com/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Coded by Witold Wozniak"
//----  
#property link      "www.mqlsoft.com"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|    CG            |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----         
#property indicator_color1  clrRed
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----    
#property indicator_label1  "CG Oscillator"
//+----------------------------------------------+
//|    Trigger       |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----         
#property indicator_color2  clrBlue
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  1
#property indicator_width2  1
//----    
#property indicator_label2  "Trigger"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int Length=10;//   
input int Shift=0;  //       
//+----------------------------------------------+
//----   ,    
//----      
double CGBuffer[];
double TriggerBuffer[];
//----      
int min_rates_total;
//----   
double CGshift;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=Length;
//----    
   CGshift=(Length+1.0)/2.0;
//----      
   SetIndexBuffer(0,CGBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  3
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,3);
//----      
   SetIndexBuffer(1,TriggerBuffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  3
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,3);
//----      
   string shortname;
   StringConcatenate(shortname,"CG Oscillator(",Length,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----    
   int first,bar;
   double price,Num,Denom;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_total; //      
     }
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      Num=0.0;
      Denom=0.0;
      //----
      for(int count=0; count<Length; count++)
        {
         price=(high[bar-count]+low[bar-count])/2.0;
         Num += (1.0 + count) * price;
         Denom+=price;
        }
      if(Denom!=0.0) CGBuffer[bar]=-Num/Denom+CGshift;
      else  CGBuffer[bar]=0.0;

      TriggerBuffer[bar]=CGBuffer[bar-1];
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
