//+------------------------------------------------------------------+
//|                                      Exp_CenterOfGravityOSMA.mq5 |
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"
//+---------------------------------------------------+
//|                                  |
//+---------------------------------------------------+
#include <TradeAlgorithms.mqh>
//+---------------------------------------------------+
//|                             |
//+---------------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+---------------------------------------------------+
//|                           |
//+---------------------------------------------------+
input double MM=0.1;              //       
input MarginMode MMMode=LOT;      //    
input int    StopLoss_=1000;      //   
input int    TakeProfit_=2000;    //   
input int    Deviation_=10;       // .    
input bool   BuyPosOpen=true;     //      
input bool   SellPosOpen=true;    //      
input bool   BuyPosClose=true;    //      
input bool   SellPosClose=true;   //      
//+-----------------------------------------------+
//|     2pbIdealMA  |
//+-----------------------------------------------+
input ENUM_TIMEFRAMES InpInd_Timeframe=PERIOD_H4; //  
input uint SignalBar=1; //      
//+-----------------------------------------------+
//|                  |
//+-----------------------------------------------+
input uint Period_=10; //   
input uint SmoothPeriod1=3; //    
input ENUM_MA_METHOD MA_Method_1=MODE_SMA; //    
input uint SmoothPeriod2=3; //    
input ENUM_MA_METHOD MA_Method_2=MODE_SMA; //    
input Applied_price_ AppliedPrice=PRICE_CLOSE_;//  
//+-----------------------------------------------+
//----          
int TimeShiftSec;
//----      
int InpInd_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//                                                  | 
//+------------------------------------------------------------------+
#include <TradeAlgorithms.mqh>
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//----    CenterOfGravityOSMA
   InpInd_Handle=iCustom(Symbol(),InpInd_Timeframe,"CenterOfGravityOSMA",
                         Period_,SmoothPeriod1,MA_Method_1,SmoothPeriod2,MA_Method_2,AppliedPrice);
   if(InpInd_Handle==INVALID_HANDLE)
     {
      Print("     CenterOfGravityOSMA");
      return(INIT_FAILED);
     }
//----          
   TimeShiftSec=PeriodSeconds(InpInd_Timeframe);
//----     
   min_rates_total=int(Period_+1+SmoothPeriod1+SmoothPeriod2+2);
   min_rates_total+=int(3+SignalBar);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//----
   GlobalVariableDel_(Symbol());
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//----       
   if(BarsCalculated(InpInd_Handle)<min_rates_total) return;
//----       IsNewBar()  SeriesInfoInteger()  
   LoadHistory(TimeCurrent()-PeriodSeconds(InpInd_Timeframe)-1,Symbol(),InpInd_Timeframe);
//----   
   double macd[3];
//----   
   static bool Recount=true;
   static bool BUY_Open=false,BUY_Close=false;
   static bool SELL_Open=false,SELL_Close=false;
   static datetime UpSignalTime,DnSignalTime;
   static CIsNewBar NB;
//----    
   if(!SignalBar || NB.IsNewBar(Symbol(),InpInd_Timeframe) || Recount) //     
     {
      //----   
      BUY_Open=false;
      SELL_Open=false;
      BUY_Close=false;
      SELL_Close=false;
      Recount=false;
      //----      
      if(CopyBuffer(InpInd_Handle,0,SignalBar,3,macd)<=0) {Recount=true; return;}
      //----    
      if(macd[1]<macd[2])
        {
         if(BuyPosOpen && macd[0]>macd[1]) BUY_Open=true;
         if(SellPosClose) SELL_Close=true;
         UpSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }
      //----    
      if(macd[1]>macd[2])
        {
         if(SellPosOpen && macd[0]<macd[1]) SELL_Open=true;
         if(BuyPosClose) BUY_Close=true;
         DnSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }
     }
//----  
//----   
   BuyPositionClose(BUY_Close,Symbol(),Deviation_);
//----   
   SellPositionClose(SELL_Close,Symbol(),Deviation_);
//----   
   BuyPositionOpen(BUY_Open,Symbol(),UpSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);
//----   
   SellPositionOpen(SELL_Open,Symbol(),DnSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);
  }
//+------------------------------------------------------------------+
