//+------------------------------------------------------------------+
//|                                                     RSICloud.mq5 |
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----    2
#property indicator_buffers 2 
//----    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrTurquoise,clrGold
//----   
#property indicator_label1  "RSICloud"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1   70.0
#property indicator_level2   50.0
#property indicator_level3   30.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint RSIPeriod=14;           //  RSI 
//+----------------------------------------------+
//----   ,    
//----      
double ExtABuffer[],ExtBBuffer[];
//----       
int IndA_Handle,IndB_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----     
   min_rates_total=int(RSIPeriod);
//---    iRSI HIGH
   IndA_Handle=iRSI(Symbol(),PERIOD_CURRENT,RSIPeriod,PRICE_HIGH);
   if(IndA_Handle==INVALID_HANDLE)
     {
      Print("      iRSI HIGH");
      return(INIT_FAILED);
     }
//---    iRSI LOW
   IndB_Handle=iRSI(Symbol(),PERIOD_CURRENT,RSIPeriod,PRICE_LOW);
   if(IndB_Handle==INVALID_HANDLE)
     {
      Print("      iRSI LOW");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,ExtABuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtABuffer,true);
//----      
   SetIndexBuffer(1,ExtBBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtBBuffer,true);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"RSICloud");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total
      || BarsCalculated(IndA_Handle)<rates_total
      || BarsCalculated(IndB_Handle)<rates_total) return(RESET);
//----    
   int to_copy;
//----     
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      to_copy=rates_total; //      
     }
   else to_copy=rates_total-prev_calculated+1; //      
//----      
   if(CopyBuffer(IndA_Handle,0,0,to_copy,ExtABuffer)<=0) return(RESET);
   if(CopyBuffer(IndB_Handle,0,0,to_copy,ExtBBuffer)<=0) return(RESET);
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
