//+------------------------------------------------------------------+
//|                                    Chande_Kroll_Stop_v1_Sign.mq5 |
//|                                  Copyright  2006, Forex-TSD.com |
//|                         Written by IgorAD,igorad2003@yahoo.co.uk |   
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |                                      
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Forex-TSD.com "
#property link      "http://www.forex-tsd.com/"
#property description ""
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        Gold 
#property indicator_color1  clrGold
//---    1  2
#property indicator_width1  2
//---    
#property indicator_label1  "Chande_Kroll_Stop_v1 Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        DodgerBlue 
#property indicator_color2  clrDodgerBlue
//---    2  2
#property indicator_width2  2
//---    
#property indicator_label2 "Chande_Kroll_Stop_v1 Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint   Length=20;
input uint   ATRPeriod=10;
input double Kv=3;
input int    Shift=0; //       
//+----------------------------------------------+
//----   ,    
//----      
double SellBuffer[];
double BuyBuffer[];
//----      
int ATR_Handle,ATR1_Handle;
//----      
int min_rates_total;
//----   ,    
//----      
int Count[];
double smin[],smax[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
   int numb,Max1,Max2;
   static int count=1;
//---
   Max2=Size;
   Max1=Max2-1;
//---
   count--;
   if(count<0) count=Max1;
//---
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+    
int OnInit()
  {
//----     
   int ATRPeriod1=15;
   min_rates_total=int(ATRPeriod+Length)+3;
   MathMax(min_rates_total,ATRPeriod1);
//----    ATR
   ATR_Handle=iATR(NULL,0,ATRPeriod);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----    ATR1
   ATR1_Handle=iATR(NULL,0,ATRPeriod1);
   if(ATR1_Handle==INVALID_HANDLE)
     {
      Print("      ATR1");
      return(INIT_FAILED);
     }
//----       
   ArrayResize(Count,Length);
   ArrayResize(smin,Length);
   ArrayResize(smax,Length);
   ArrayInitialize(smin,-999999);
   ArrayInitialize(smax,+999999);
   ArraySetAsSeries(smin,true);
   ArraySetAsSeries(smax,true);
   ArraySetAsSeries(Count,0);
//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,124);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----          
   ArraySetAsSeries(SellBuffer,true);
//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,124);
//----    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----          
   ArraySetAsSeries(BuyBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"Chande_Kroll_Stop_v1_Sign(",Length,", ",ATRPeriod,", ",Kv,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total
      || BarsCalculated(ATR1_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//----    
   int limit,to_copy,bar;
   double ATR[],ATR1[],UpTrend0,DnTrend0;
   static double UpTrend1,DnTrend1;
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(ATR1,true);
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=rates_total-1-int(ATRPeriod); //      
     }
   else limit=rates_total-prev_calculated; //      

   to_copy=limit+1;
//----      
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
   if(CopyBuffer(ATR1_Handle,0,0,to_copy,ATR1)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      smin[Count[0]]=high[ArrayMaximum(high,bar,ATRPeriod)]-Kv*ATR[bar];
      smax[Count[0]]=low[ArrayMinimum(low,bar,ATRPeriod)]+Kv*ATR[bar];
      UpTrend0=smin[ArrayMaximum(smin,0,WHOLE_ARRAY)];
      DnTrend0=smax[ArrayMinimum(smax,0,WHOLE_ARRAY)];
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      if(UpTrend1<=DnTrend1 && UpTrend0>DnTrend0) BuyBuffer[bar]=low[bar]-ATR1[bar]*3/8;
      if(UpTrend1>=DnTrend1 && UpTrend0<DnTrend0) SellBuffer[bar]=high[bar]+ATR1[bar]*3/8;
      //---
      if(bar)
        {
         UpTrend1=UpTrend0;
         DnTrend1=DnTrend0;
         Recount_ArrayZeroPos(Count,Length);
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
