//+---------------------------------------------------------------------+
//|                                                         BlauTVI.mq5 |
//|                                  Copyright  2013, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
//----  
#property copyright "Copyright  2013, Nikolay Kositsin"
//----    
#property link "farria@mail.redcom.ru" 
#property description "Tick Volume Index"
//----   
#property version   "1.01"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   1
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----    
#property indicator_color1 clrMagenta,clrOrange,clrGray,clrDeepSkyBlue,clrBlue
//----     2
#property indicator_width1 2
//----   
#property indicator_label1  "Tick Volume Index"
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2,XMA3,XMA4,XMA5;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method=MODE_EMA;           //  
input uint XLength1=12;                            //   
input uint XLength2=12;                            //   
input uint XLength3=5;                             //   
input int XPhase=15;                               //  
//----  JJMA    -100 ... +100,     
//----  VIDIA   CMO,  AMA    
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  // 
//+----------------------------------------------+
//----   ,    
//----      
double IndBuffer[],ColorIndBuffer[];
//----      
int min_rates_total,min_rates_1,min_rates_2;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_1=XMA1.GetStartBars(XMA_Method,XLength1,XPhase);
   min_rates_2=min_rates_1+XMA1.GetStartBars(XMA_Method,XLength2,XPhase);
   min_rates_total=min_rates_2+XMA1.GetStartBars(XMA_Method,XLength3,XPhase);
//----    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,4);
//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"Tick Volume Index");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,4);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----    
   double UpTicks,XUpTicks,XXUpTicks,DnTicks,XDnTicks,XXDnTicks,TVI_Raw,XTVI_Raw;
   int first,bar;
   long Vol;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_1; //      
     }
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      if(VolumeType==VOLUME_TICK) Vol=tick_volume[bar];
      else Vol=volume[bar];
      //---
      UpTicks=(Vol+(close[bar]-open[bar])/_Point)/2;
      DnTicks=Vol-UpTicks;
      XUpTicks=XMA1.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength1,UpTicks,bar,false);
      XDnTicks=XMA2.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength1,DnTicks,bar,false);
      XXUpTicks=XMA3.XMASeries(min_rates_1,prev_calculated,rates_total,XMA_Method,XPhase,XLength2,XUpTicks,bar,false);
      XXDnTicks=XMA4.XMASeries(min_rates_1,prev_calculated,rates_total,XMA_Method,XPhase,XLength2,XDnTicks,bar,false);
      TVI_Raw=100.0*(XXUpTicks-XXDnTicks)/(XXUpTicks+XXDnTicks);
      XTVI_Raw=XMA5.XMASeries(min_rates_2,prev_calculated,rates_total,XMA_Method,XPhase,XLength3,TVI_Raw,bar,false);
      IndBuffer[bar]=XTVI_Raw;
     }
   if(prev_calculated>rates_total || prev_calculated<=0) first++;
//----     Ind
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      int clr=2;
      //---
      if(IndBuffer[bar]>0)
        {
         if(IndBuffer[bar]>IndBuffer[bar-1]) clr=4;
         if(IndBuffer[bar]<IndBuffer[bar-1]) clr=3;
        }
      //---
      if(IndBuffer[bar]<0)
        {
         if(IndBuffer[bar]<IndBuffer[bar-1]) clr=0;
         if(IndBuffer[bar]>IndBuffer[bar-1]) clr=1;
        }
      //---
      ColorIndBuffer[bar]=clr;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
