//+------------------------------------------------------------------+
//|                                                     Beginner.mq5 |
//|                                      Copyright  2009, EarnForex |
//|                                        http://www.earnforex.com/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, EarnForex"
#property link      "http://www.earnforex.com"
#property version   "2.00"
#property description "Beginner - basic indicator for marking chart's highs and lows."
#property description "Repaints."
#property description "  !"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_ARROW
//----         
#property indicator_color1  clrMagenta
//----    1  2
#property indicator_width1  2
//----    
#property indicator_label1  "Beginner Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----        DodgerBlue 
#property indicator_color2  clrDodgerBlue
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2 "Beginner Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define  RESET     0 //        
#define  UP       +1
#define  DOWN     -1
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Otstup = 30; //Shift
input uint Per=9;       //Period
//----   ,    
//----      
double SellBuffer[];
double BuyBuffer[];
//----      
int min_rates_total,ATRPeriod;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----   
   ATRPeriod=10;
   min_rates_total=int(MathMax(Per,ATRPeriod));
//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"Beginner Sell");
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,108);
//----    ,   
   ArraySetAsSeries(SellBuffer,true);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----      DataWindow
   PlotIndexSetString(1,PLOT_LABEL,"Beginner Buy");
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,108);
//----    ,   
   ArraySetAsSeries(BuyBuffer,true);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string short_name="Beginner";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
  }
//+------------------------------------------------------------------+
//| GetRange()                                                       |
//+------------------------------------------------------------------+
double GetRange(uint Len,const double &H[],const double &L[],int index)
  {
   double AvgRange,Range;
//---
   AvgRange=0.0;
   for(int count=index; count<int(index+Len); count++) AvgRange+=MathAbs(H[count]-L[count]);
   Range=AvgRange/Len;
//----
   return(Range);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----    
   int limit,bar;
   double Range,SHMax,SHMin,diff;
   static int trend;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      trend=0;
     }
   else limit=rates_total-prev_calculated; //      
//----    ,     
   ArraySetAsSeries(High,true);
   ArraySetAsSeries(Low,true);
   ArraySetAsSeries(Close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      Range=GetRange(ATRPeriod,High,Low,bar)/3;
      SellBuffer[bar]=0;
      BuyBuffer[bar]=0;
//---
      SHMax=High[ArrayMaximum(High,bar,Per)];
      SHMin=Low[ArrayMinimum(Low,bar,Per)];
      diff=(SHMax-SHMin)*Otstup/100.0;
//---
      if(Close[bar]<SHMin+diff && trend!=DOWN)
        {
         SellBuffer[bar]=High[bar]+Range;
         if(bar) trend=DOWN;
        }
      else if(Close[bar]>SHMax-diff && trend!=UP)
        {
         BuyBuffer[bar]=Low[bar]-Range;
         if(bar) trend=UP;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
