//+------------------------------------------------------------------+
//|                                                Gaus_MA_StDev.mq5 |
//|                            Copyright  2009, Gregory A. Kakhiani |
//|                                              gkakhiani@gmail.com | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, Gregory A. Kakhiani"
#property link      "gkakhiani@gmail.com"
#property version   "1.00"
//---
#property description " (  )     "
#property description "-  ,    "
#property description "  -  ( )."
#property description "          "
//----     
#property indicator_chart_window
//----        
#property indicator_buffers 6
//----     
#property indicator_plots   5
//----     
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrGray,clrTeal,clrCrimson
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "GaussAverage"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----        
#property indicator_color2  clrRed
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "Dn_Signal 1"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----        
#property indicator_color3  clrAqua
//----    3  2
#property indicator_width3  2
//----    
#property indicator_label3  "Up_Signal 1"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_ARROW
//----        
#property indicator_color4  clrRed
//----    4  4
#property indicator_width4  4
//----    
#property indicator_label4  "Dn_Signal 2"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   5   
#property indicator_type5   DRAW_ARROW
//----        
#property indicator_color5  clrAqua
//----    5  4
#property indicator_width5  4
//----    
#property indicator_label5  "Up_Signal 2"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_, //PRICE_TRENDFOLLOW0_
   PRICE_TRENDFOLLOW1_  //PRICE_TRENDFOLLOW1_
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint      period=10;      //   
input double    N_=2;            //  
input double    A=-0.001;       //   
input bool      Vol=false;      //   
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  // 
input Applied_price_ Applied_Price=PRICE_CLOSE_;//  
/* ,      ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input int Shift=0; //      
input double dK1=1.5;  //  1   
input double dK2=2.5;  //  2   
input uint std_period=9; //   
input int PriceShift=0; //      
//----   ,    
//----      
double ExtLineBuffer[];
double ColorExtLineBuffer[];
double BearsBuffer1[],BullsBuffer1[];
double BearsBuffer2[],BullsBuffer2[];
//----
double N,dPriceShift;
double dGausMA[];
double Coefs[]; //   
//----      
int min_rates_1,min_rates_total,AvPeriod;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----      
   if(dK1>=dK2)
     {
      Print("       1  2   !");
      return(INIT_FAILED);
     }
//----  
   AvPeriod=int(period);
   min_rates_1=AvPeriod;
   min_rates_total=min_rates_1+1+int(std_period);
   ArrayResize(Coefs,AvPeriod);
   N=N_;
   if(MathAbs(N)>5) N=5;
//----       
   ArrayResize(dGausMA,std_period);
//----   
   for(int iii=0; iii<AvPeriod; iii++) Coefs[iii]=MathExp(A*MathPow(iii,N));
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,"Gaus_MA_StDev");
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----     ,     
   SetIndexBuffer(1,ColorExtLineBuffer,INDICATOR_COLOR_INDEX);
//----    BearsBuffer   
   SetIndexBuffer(2,BearsBuffer1,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    BullsBuffer   
   SetIndexBuffer(3,BullsBuffer1,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    BearsBuffer   
   SetIndexBuffer(4,BearsBuffer2,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(3,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    BullsBuffer   
   SetIndexBuffer(5,BullsBuffer2,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(4,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    
   dPriceShift=_Point*PriceShift;
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total)
      return(0);

//----    
   int first,bar;
   double sum=0; //    
   double W=0;   //    
   double SMAdif,Sum,StDev,dstd,BEARS1,BULLS1,BEARS2,BULLS2,Filter1,Filter2,GausMA;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_1; //      
     }
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      sum=0;
      W=0;
      //----
      for(int kkk=0; kkk<AvPeriod; kkk++)
         if(Vol)
           {
            if(VolumeType==VOLUME_TICK)
              {
               sum+=PriceSeries(Applied_Price,bar-kkk,open,low,high,close)*tick_volume[bar]*Coefs[kkk];
               W+=Coefs[kkk]*tick_volume[bar];
              }
            else
              {
               sum+=PriceSeries(Applied_Price,bar-kkk,open,low,high,close)*volume[bar]*Coefs[kkk];
               W+=Coefs[kkk]*volume[bar];
              }
           }
      else
        {
         sum+=PriceSeries(Applied_Price,bar-kkk,open,low,high,close)*Coefs[kkk];
         W+=Coefs[kkk];
        }
      //----      
      ExtLineBuffer[bar]=sum/W+dPriceShift;
     }
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first++;
//----     
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      ColorExtLineBuffer[bar]=0;
      if(ExtLineBuffer[bar-1]<ExtLineBuffer[bar]) ColorExtLineBuffer[bar]=1;
      if(ExtLineBuffer[bar-1]>ExtLineBuffer[bar]) ColorExtLineBuffer[bar]=2;
     }
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total;
//----      
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----        
      for(int iii=0; iii<int(std_period); iii++) dGausMA[iii]=ExtLineBuffer[bar-iii]-ExtLineBuffer[bar-iii-1];
      //----     
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=dGausMA[iii];
      SMAdif=Sum/std_period;
      //----       
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=MathPow(dGausMA[iii]-SMAdif,2);
      //----      StDev   
      StDev=MathSqrt(Sum/std_period);
      //----  
      dstd=NormalizeDouble(dGausMA[0],_Digits+2);
      Filter1=NormalizeDouble(dK1*StDev,_Digits+2);
      Filter2=NormalizeDouble(dK2*StDev,_Digits+2);
      BEARS1=EMPTY_VALUE;
      BULLS1=EMPTY_VALUE;
      BEARS2=EMPTY_VALUE;
      BULLS2=EMPTY_VALUE;
      GausMA=ExtLineBuffer[bar];
      //----   
      if(dstd<-Filter1 && dstd>=-Filter2) BEARS1=GausMA; //  
      if(dstd<-Filter2) BEARS2=GausMA; //  
      if(dstd>+Filter1 && dstd<=+Filter2) BULLS1=GausMA; //  
      if(dstd>+Filter2) BULLS2=GausMA; //  
      //----       
      BullsBuffer1[bar]=BULLS1;
      BearsBuffer1[bar]=BEARS1;
      BullsBuffer2[bar]=BULLS2;
      BearsBuffer2[bar]=BEARS2;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+  
//| PriceSeries() function                                           |
//+------------------------------------------------------------------+
double PriceSeries(
                   uint applied_price,//  
                   uint   bar,//            ).
                   const double &Open[],
                   const double &Low[],
                   const double &High[],
                   const double &Close[])
  {
//----
   switch(applied_price)
     {
      //----     ENUM_APPLIED_PRICE
      case  PRICE_CLOSE: return(Close[bar]);
      case  PRICE_OPEN: return(Open [bar]);
      case  PRICE_HIGH: return(High [bar]);
      case  PRICE_LOW: return(Low[bar]);
      case  PRICE_MEDIAN: return((High[bar]+Low[bar])/2.0);
      case  PRICE_TYPICAL: return((Close[bar]+High[bar]+Low[bar])/3.0);
      case  PRICE_WEIGHTED: return((2*Close[bar]+High[bar]+Low[bar])/4.0);
      //----                            
      case  8: return((Open[bar] + Close[bar])/2.0);
      case  9: return((Open[bar] + Close[bar] + High[bar] + Low[bar])/4.0);
      //----                                
      case 10:
        {
         if(Close[bar]>Open[bar])return(High[bar]);
         else
           {
            if(Close[bar]<Open[bar])
               return(Low[bar]);
            else return(Close[bar]);
           }
        }
      //----         
      case 11:
        {
         if(Close[bar]>Open[bar])return((High[bar]+Close[bar])/2.0);
         else
           {
            if(Close[bar]<Open[bar])
               return((Low[bar]+Close[bar])/2.0);
            else return(Close[bar]);
           }
         break;
        }
      //----
      default: return(Close[bar]);
     }
  }
//+------------------------------------------------------------------+
