//+------------------------------------------------------------------+
//|                                                      Gaus_MA.mq5 |
//|                            Copyright  2009, Gregory A. Kakhiani |
//|                                              gkakhiani@gmail.com | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, Gregory A. Kakhiani"
#property link      "gkakhiani@gmail.com"
#property version   "1.00"
//---
#property description " (  )     "
#property description "-  ,    "
#property description "  -  ( )"
//----     
#property indicator_chart_window
//----        
#property indicator_buffers 2
//----     
#property indicator_plots   1
//----     
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrGray,clrTeal,clrCrimson
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "GaussAverage"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_, //PRICE_TRENDFOLLOW0_
   PRICE_TRENDFOLLOW1_  //PRICE_TRENDFOLLOW1_
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint      period=10;      //   
input double    N_=2;           //  
input double    A=-0.001;       //   
input bool      Vol=false;      //   
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  // 
input Applied_price_ Applied_Price=PRICE_CLOSE_;//  
/* ,      ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input int Shift=0; //      
input int PriceShift=0; //      
//----   ,    
//----      
double ExtLineBuffer[];
double ColorExtLineBuffer[];
//---
double N,dPriceShift;
double Coefs[]; //   
//----      
int min_rates_total,AvPeriod;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----  
   AvPeriod=int(period);
//--- AvPeriod=MathMin(period,49);
   min_rates_total=AvPeriod+1;
   ArrayResize(Coefs,AvPeriod);
   N=N_;
   if(MathAbs(N)>5) N=5;
//---   
   for(int iii=0; iii<AvPeriod; iii++) Coefs[iii]=MathExp(A*MathPow(iii,N));
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"GaussAverage");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----     ,     
   SetIndexBuffer(1,ColorExtLineBuffer,INDICATOR_COLOR_INDEX);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---    
   dPriceShift=_Point*PriceShift;
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total)
      return(0);
//----    
   int first,bar;
   double sum=0; //    
   double W=0;   //    
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_total; //      
     }
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total; bar++)
     {
      sum=0;
      W=0;
      //---
      for(int kkk=0; kkk<AvPeriod; kkk++)
         if(Vol)
           {
            if(VolumeType==VOLUME_TICK)
              {
               sum+=PriceSeries(Applied_Price,bar-kkk,open,low,high,close)*tick_volume[bar]*Coefs[kkk];
               W+=Coefs[kkk]*tick_volume[bar];
              }
            else
              {
               sum+=PriceSeries(Applied_Price,bar-kkk,open,low,high,close)*volume[bar]*Coefs[kkk];
               W+=Coefs[kkk]*volume[bar];
              }
           }
      else
        {
         sum+=PriceSeries(Applied_Price,bar-kkk,open,low,high,close)*Coefs[kkk];
         W+=Coefs[kkk];
        }
      //----      
      ExtLineBuffer[bar]=sum/W+dPriceShift;
     }
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first++;
//----     
   for(bar=first; bar<rates_total; bar++)
     {
      ColorExtLineBuffer[bar]=0;
      if(ExtLineBuffer[bar-1]<ExtLineBuffer[bar]) ColorExtLineBuffer[bar]=1;
      if(ExtLineBuffer[bar-1]>ExtLineBuffer[bar]) ColorExtLineBuffer[bar]=2;
     }
//----
   return(rates_total);
  }
//+------------------------------------------------------------------+  
//| PriceSeries() function                                           |
//+------------------------------------------------------------------+
double PriceSeries(uint applied_price,//  
                   uint   bar,//            ).
                   const double &Open[],
                   const double &Low[],
                   const double &High[],
                   const double &Close[])
  {
   switch(applied_price)
     {
      //----     ENUM_APPLIED_PRICE
      case  PRICE_CLOSE: return(Close[bar]);
      case  PRICE_OPEN: return(Open [bar]);
      case  PRICE_HIGH: return(High [bar]);
      case  PRICE_LOW: return(Low[bar]);
      case  PRICE_MEDIAN: return((High[bar]+Low[bar])/2.0);
      case  PRICE_TYPICAL: return((Close[bar]+High[bar]+Low[bar])/3.0);
      case  PRICE_WEIGHTED: return((2*Close[bar]+High[bar]+Low[bar])/4.0);
      //----                            
      case  8: return((Open[bar] + Close[bar])/2.0);
      case  9: return((Open[bar] + Close[bar] + High[bar] + Low[bar])/4.0);
      //----                                
      case 10:
        {
         if(Close[bar]>Open[bar])return(High[bar]);
         else
           {
            if(Close[bar]<Open[bar])
               return(Low[bar]);
            else return(Close[bar]);
           }
        }
      //----         
      case 11:
        {
         if(Close[bar]>Open[bar])return((High[bar]+Close[bar])/2.0);
         else
           {
            if(Close[bar]<Open[bar])
               return((Low[bar]+Close[bar])/2.0);
            else return(Close[bar]);
           }
         break;
        }
      //----
      default: return(Close[bar]);
     }
  }
//+------------------------------------------------------------------+
