//+------------------------------------------------------------------+
//|                                              Begin_Trend_v01.mq5 |
//|                                   Copyright  2014, Inkov Evgeni | 
//|                                                    ew123@mail.ru | 
//+------------------------------------------------------------------+ 
//---  
#property copyright "Copyright  2014, Inkov Evgeni"
//---  
#property link      "ew123@mail.ru"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|    +             |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         
#property indicator_color1  clrLimeGreen
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  2
#property indicator_width1  2
//---    
#property indicator_label1  "Begin_Trend_v01 Up"
//+----------------------------------------------+
//|    -             |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---         
#property indicator_color2  clrRed
//---   2 -  
#property indicator_style2  STYLE_SOLID
//---    2  2
#property indicator_width2  2
//---    
#property indicator_label2  "Begin_Trend_v01 Down"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_SOLID
#property indicator_levelwidth 3
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Period_Channel=70;
input uint Period_Input=48;
input int Shift=0;          //       
//+----------------------------------------------+
//---   ,   
//---      
double UpBuffer[];
double DnBuffer[];
//---      
int Up_Handle,Dn_Handle,Md_Handle;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=int(MathMax(Period_Channel,Period_Input));
//---    iMA
   Up_Handle=iMA(NULL,0,Period_Channel,0,MODE_LWMA,PRICE_HIGH);
   if(Up_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//---    iMA
   Md_Handle=iMA(NULL,0,Period_Input,0,MODE_SMA,PRICE_CLOSE);
   if(Md_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//---    iMA
   Dn_Handle=iMA(NULL,0,Period_Channel,0,MODE_LWMA,PRICE_LOW);
   if(Dn_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,UpBuffer,INDICATOR_DATA);
//---    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(UpBuffer,true);
//---      
   SetIndexBuffer(1,DnBuffer,INDICATOR_DATA);
//---    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(DnBuffer,true);
//---      
   string shortname="Begin_Trend_v01";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(Up_Handle)<rates_total
      || BarsCalculated(Md_Handle)<rates_total
      || BarsCalculated(Dn_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//---    
   int to_copy,limit;
   double Up[],Md[],Dn[];
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-2; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+1;
//---      
   if(CopyBuffer(Up_Handle,0,0,to_copy,Up)<=0) return(RESET);
   if(CopyBuffer(Md_Handle,0,0,to_copy,Md)<=0) return(RESET);
   if(CopyBuffer(Dn_Handle,0,0,to_copy,Dn)<=0) return(RESET);
//---         
   ArraySetAsSeries(Up,true);
   ArraySetAsSeries(Md,true);
   ArraySetAsSeries(Dn,true);
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      UpBuffer[bar]=Up[bar]-Md[bar];
      DnBuffer[bar]=Dn[bar]-Md[bar];
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
