//+------------------------------------------------------------------+
//|                                                  Interchange.mqh |
//|                                           Copyright 2015, MigVRN |
//|                                                    Miguzov@bk.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright 2015, MigVRN"
#property link      "https://login.mql5.com/ru/users/MigVRN"

#define BUFFER_MAX_SIZE 500000     //Max size struct for transmit 
#define BUFFER_STEP     5000       //The number global variables of terminal
//+------------------------------------------------------------------+
//| Custom chartevent for class
//+------------------------------------------------------------------+
enum ENUM_CHART_EVENT_GLOBAL_VARIABLES
  {
   CHARTEVENT_SEND_DATA             =0x00000001,  
   CHARTEVENT_SEND_DATA_FINISH      =0x00000002,  
   CHARTEVENT_GET_DATA              =0x00000004, 
   CHARTEVENT_GET_DATA_FINISH       =0x00000008,   
   CHARTEVENT_GIVE_NEW_DATA         =0x00000010  
  };
//+------------------------------------------------------------------+
//|  Buffer for data                                                 |
//+------------------------------------------------------------------+
struct GlobalVariablBuffer
  {
   double            buffer[BUFFER_MAX_SIZE];
  };
//+------------------------------------------------------------------+
//|  Class to exchange information                                   |
//+------------------------------------------------------------------+
class CInterchange
  {
private:
   GlobalVariablBuffer m_data;           
   double            m_tmp[BUFFER_STEP]; 

   string            m_prefix_name;    

   bool              m_flag_save;        
   bool              m_flag_start_load;   
   bool              m_flag_finish_load; 

   int               m_number_iteration;  
   ushort            m_chartevent_custom;  
   int               m_count_iteration;    

   long              m_ChartID;            

public:
   void              CInterchange(void):    m_prefix_name("Tmp"),
                                            m_flag_save(false),
                                            m_flag_start_load(false),
                                            m_flag_finish_load(false),
                                            m_number_iteration(0),
                                            m_ChartID(ChartID()),
                                            m_chartevent_custom(1001) {};
   void             ~CInterchange(void) {};

   template<typename T>
   bool              SendDataStart(T &Struct);

   template<typename T>
   bool              GetDataStart(T &Struct);

   template<typename T>
   bool              GetDataFinish(T &Struct);

   void              GiveNewData();

   bool              OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam);
   void              Destroy();

   void              SetPrefixNameForLoad(const string prefix) {m_prefix_name=prefix;}
   void              SetPrefixNameForSave(const string prefix) {Destroy(); m_prefix_name=prefix; for(int i=0; i<BUFFER_STEP; i++) GlobalVariableSet(m_prefix_name+"["+(string)i+"]",0);}
   void              SetChartID(const long chartID) {m_ChartID=chartID;}
   void              SetChartEvent(const ushort chartevent_custom) {m_chartevent_custom=chartevent_custom;}

   string            GetPrefixName() {return(m_prefix_name);}
   long              GetChartID() {return(m_ChartID);}
   ushort            GetChartEvent() {return(m_chartevent_custom);}
  };
//+------------------------------------------------------------------+
//|  Start send data for programms                                   |
//+------------------------------------------------------------------+
template<typename T>
bool CInterchange::SendDataStart(T &Struct)
  {
   double Size_struct=sizeof(Struct);

   if(Size_struct>sizeof(m_data))
     {
      Print("Error! Struct is very big. Needs to increase BUFFER_MAX_SIZE!");
      Destroy();
      return(false);
     }

   m_data=(GlobalVariablBuffer)Struct;
   
   m_flag_save=true;

   m_flag_start_load  = false;
   m_flag_finish_load = false;

   m_number_iteration = 0;
   m_count_iteration  = 0;

   m_count_iteration=(int)MathCeil(Size_struct/(BUFFER_STEP*8.0));

   EventChartCustom(m_ChartID,m_chartevent_custom,(long)CHARTEVENT_SEND_DATA,0,m_prefix_name);

   return(true);
  }
//+------------------------------------------------------------------+
//|  Start get data                                                  |
//+------------------------------------------------------------------+
template<typename T>
bool CInterchange::GetDataStart(T &Struct)
  {
   double Size_data=sizeof(Struct);

   if(Size_data>sizeof(m_data))
     {
      Print("Error! Struct is very big. Needs to increase BUFFER_MAX_SIZE!");
      return(false);
     }

   m_flag_save=false;

   m_flag_start_load  = true;
   m_flag_finish_load = false;
   m_number_iteration = 0;
   m_count_iteration  = 0;

   m_count_iteration=(int)MathCeil(Size_data/(BUFFER_STEP*8.0));

   return(true);
  }
//+------------------------------------------------------------------+
//|  Finish get data                                                 |
//+------------------------------------------------------------------+
template<typename T>
bool CInterchange::GetDataFinish(T &Struct)
  {
   if(!m_flag_finish_load)
     {
      return(false);
     }

   double Size_data=sizeof(Struct);

   if(Size_data>sizeof(m_data))
     {
      Print("Error! Struct is very big. Needs to increase BUFFER_MAX_SIZE!");
      return(false);
     }

   Struct=(T)m_data;

   m_flag_save=false;

   m_flag_start_load  = true;
   m_flag_finish_load = false;
   m_number_iteration = 0;

   return(true);
  }
//+------------------------------------------------------------------+
//|  Chart event                                                     |
//+------------------------------------------------------------------+
bool CInterchange::OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam)
  {
   if(id!=CHARTEVENT_CUSTOM+m_chartevent_custom || sparam!=m_prefix_name)
      return(true);

   switch((ENUM_CHART_EVENT_GLOBAL_VARIABLES)lparam)
     {
      case CHARTEVENT_SEND_DATA:
        {
         if(!m_flag_save) return(false);

         m_number_iteration=(int)dparam;

         if(m_number_iteration>m_count_iteration) return(false);

         for(int i=0; i<BUFFER_STEP; i++)
           {
            if(GlobalVariableSet(m_prefix_name+"["+(string)i+"]",m_data.buffer[m_number_iteration*BUFFER_STEP+i])==0) return(false);                
           }

         EventChartCustom(m_ChartID,m_chartevent_custom,(long)CHARTEVENT_GET_DATA,(double)m_number_iteration,m_prefix_name);
         return(true);
        }
 
      case CHARTEVENT_SEND_DATA_FINISH:
        {
         if(!m_flag_save) return(false);

         m_number_iteration=(int)dparam;

         if(m_number_iteration!=m_count_iteration) return(false);

         EventChartCustom(m_ChartID,m_chartevent_custom,(long)CHARTEVENT_GET_DATA_FINISH,(double)m_number_iteration,m_prefix_name);

         m_number_iteration=0;
         m_flag_save=false;
         
         m_flag_start_load  = false;
         m_flag_finish_load = false;

         return(true);
        }
        
      case CHARTEVENT_GET_DATA:
        {
         if(!m_flag_start_load) return(true);

         if(m_number_iteration!=(long)dparam)
           {
            EventChartCustom(m_ChartID,m_chartevent_custom,(long)CHARTEVENT_SEND_DATA,(double)m_number_iteration,m_prefix_name);
            return(false);
           }

         for(int i=0; i<BUFFER_STEP; i++)
           {
            if(!GlobalVariableGet(m_prefix_name+"["+(string)i+"]",m_data.buffer[m_number_iteration*BUFFER_STEP+i]))
               return(false);
           }

         if(m_number_iteration==m_count_iteration)
           {
            EventChartCustom(m_ChartID,m_chartevent_custom,(long)CHARTEVENT_SEND_DATA_FINISH,(double)m_number_iteration,m_prefix_name);
            return(true);
           }

         m_number_iteration++;
         EventChartCustom(m_ChartID,m_chartevent_custom,(long)CHARTEVENT_SEND_DATA,(double)m_number_iteration,m_prefix_name);
         return(true);
        }
        
      case CHARTEVENT_GET_DATA_FINISH:
        {
         if(!m_flag_start_load) return(true);

         m_number_iteration=0;
         m_flag_start_load  = false;
         m_flag_finish_load = true;
         return(true);
        }
     }
   return(false);
  }
//+------------------------------------------------------------------+
//|  Delete all global variables                                     |
//+------------------------------------------------------------------+
void CInterchange::Destroy()
  {
   GlobalVariablesDeleteAll(m_prefix_name);

   m_flag_save=false;
   m_flag_start_load=false;
   m_flag_finish_load=false;
   m_number_iteration=0;
  }
//+------------------------------------------------------------------+
//|  Start transmit new data                                         |
//+------------------------------------------------------------------+  
void CInterchange::GiveNewData()
  {
   EventChartCustom(m_ChartID,m_chartevent_custom,(long)CHARTEVENT_GIVE_NEW_DATA,0,m_prefix_name);
  }
//+-------------------------------------------------------------------+  