//+------------------------------------------------------------------+
//|                                           Interchange_Expert.mq5 |
//|                                           Copyright 2015, MigVRN |
//|                                                    Miguzov@bk.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright 2015, MigVRN"
#property link      "https://login.mql5.com/ru/users/MigVRN"
#property version   "1.00"

#include <My_struct.mqh>
#include <Interchange.mqh>

Indicator_data Exp_Data;        
CInterchange Exp_buffer;     

int handle_indicator;              
int number_iteration;         
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   MqlParam Param_ind[1];
   Param_ind[0].type=TYPE_STRING;
   Param_ind[0].string_value="Interchange_Indicator.ex5";
   handle_indicator=IndicatorCreate(_Symbol,_Period,IND_CUSTOM,1,Param_ind);
   ChartIndicatorAdd(0,1,handle_indicator);
   number_iteration=0;
   
   Exp_buffer.SetPrefixNameForSave(_Symbol+"_"+(string)_Period);
   
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   Exp_buffer.Destroy();
   ChartIndicatorDelete(0,1,"Test("+_Symbol+" "+EnumToString((ENUM_TIMEFRAMES)_Period)+")");
   IndicatorRelease(handle_indicator);
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   Exp_buffer.OnEvent(id,lparam,dparam,sparam);
   
   if(id==CHARTEVENT_CUSTOM+Exp_buffer.GetChartEvent() && lparam == CHARTEVENT_GIVE_NEW_DATA)
     { 
      number_iteration++;
      CopyInfo(number_iteration);
      Exp_buffer.SendDataStart(Exp_Data);
     }  
  
   ChartRedraw();
  }
//+------------------------------------------------------------------+
//| Copy info in buffer for send data                                |
//+------------------------------------------------------------------+ 
void CopyInfo(int b)
  {
   for(int i=0; i<SIZE_BUFFER_INDICATOR; i++)
     {
      Exp_Data.AverageBuffer[i]=MathSin((i+b)*M_PI/60.0);
      Exp_Data.HighPriceBuffer[i]= MathSin((i+b)*M_PI/40.0);
      Exp_Data.LowPriceBuffer[i] = MathSin((i+b)*M_PI/20.0);
      Exp_Data.AverageColors[i]=char(2*MathRand()/32767);
      Exp_Data.LowPriceColors[i]=char(2*MathRand()/32767);
      Exp_Data.HighPriceColors[i]=char(2*MathRand()/32767);
     }
  }
//+------------------------------------------------------------------+