//+------------------------------------------------------------------+
//|                                       AdaptiveCyberCycleSign.mq5 |
//|                                                                  |
//| Adaptive Cyber Cycle                                             |
//|                                                                  |
//| Algorithm taken from book                                        |
//|     "Cybernetics Analysis for Stock and Futures"                 |
//| by John F. Ehlers                                                |
//|                                                                  |
//|                                              contact@mqlsoft.com |
//|                                          http://www.mqlsoft.com/ |
//+------------------------------------------------------------------+
//---  
#property copyright "Coded by Witold Wozniak"
//---  
#property link      "www.mqlsoft.com"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        Red 
#property indicator_color1  clrRed
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "AdaptiveCyberCycle Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        Blue 
#property indicator_color2  clrBlue
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "AdaptiveCyberCycle Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0       //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input double Alpha=0.07;    //   
input int Shift=0;          //       
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[];
double BuyBuffer[];
//---      
int CP_Handle,ATR_Handle;
//---      
int min_rates_total;
//---   ,   
//---      
int Count[];
double Smooth[],Price[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[]) //        
  {
//---
   int numb,Max1,Max2;
   static int count=1;
//---
   Max2=7;
   Max1=Max2-1;
//---
   count--;
   if(count<0) count=Max1;
//---
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   int ATR_Period=10;
   min_rates_total=int(MathMax(7+6,ATR_Period));
//---       
   ArrayResize(Count,7);
   ArrayResize(Smooth,7);
   ArrayResize(Price,7);
//---   
   ArrayInitialize(Smooth,0.0);
   ArrayInitialize(Price,0.0);
//---    CyclePeriod
   CP_Handle=iCustom(NULL,0,"CyclePeriod",Alpha);
   if(CP_Handle==INVALID_HANDLE)
     {
      Print("      CyclePeriod");
      return(INIT_FAILED);
     }
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,172);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,172);
//---    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//---      
   string shortname;
   StringConcatenate(shortname,"Adaptive Cyber Cycle Sign(",DoubleToString(Alpha,4),", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //       
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(CP_Handle)<rates_total
      || BarsCalculated(ATR_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//---    
   int MaxBar,limit,bar;
   int bar0,bar1,bar2,bar3;
   double K0,K1,K2,K3,period[1],ATR[1],alpha1,Cycle0,Trigger0;
   static double Cycle2,Cycle1,Trigger1;
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-2; //      
      Cycle2=0;
      Cycle1=0;
      Trigger1=0;
     }
   else limit=rates_total-prev_calculated; //      
//---
   MaxBar=rates_total-min_rates_total-3;
//---         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(time,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      bar0=Count[0];
      bar1=Count[1];
      bar2=Count[2];
      bar3=Count[3];
      //---
      Price[bar0]=(high[bar]+low[bar])/2.0;
      Smooth[bar0]=(Price[bar0]+2.0*Price[bar1]+2.0*Price[bar2]+Price[bar3])/6.0;
      //---
      if(bar<=MaxBar)
        {
         //---      
         if(CopyBuffer(CP_Handle,0,bar,1,period)<=0) return(RESET);
         //---  
         alpha1=2.0/(period[0]+1.0);
         K0=MathPow((1.0 - 0.5*alpha1),2);
         K1=2.0;
         K2=K1 *(1.0 - alpha1);
         K3=MathPow((1.0 - alpha1),2);
         //---
         Cycle0=K0*(Smooth[bar0]-K1*Smooth[bar1]+Smooth[bar2])+K2*Cycle1-K3*Cycle2;
        }
      else Cycle0=(Price[bar0]-2.0*Price[bar1]+Price[bar2])/4.0;
      //---
      Trigger0=Cycle1;
      //--- 
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      if(Cycle1<Trigger1 && Cycle0>Trigger0)
        {
         //---      
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
         BuyBuffer[bar]=low[bar]-ATR[0]*3/8;
        }
      //---
      if(Cycle1>Trigger1 && Cycle0<Trigger0)
        {
         //---      
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0) return(RESET);
         SellBuffer[bar]=high[bar]+ATR[0]*3/8;
        }
      //---
      if(bar>0)
        {
         Cycle2=Cycle1;
         Cycle1=Cycle0;
         Trigger1=Trigger0;
         Recount_ArrayZeroPos(Count);
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+