//+------------------------------------------------------------------+
//|                                        simple_trading_system.mq5 |
//|                               Copyright 2014, Vitalie Postolache |
//|                                             http://www.mql4.com/ |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright 2014, Vitalie Postolache"
//---    
#property link      "http://www.mql4.com/"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrDeepPink
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "simple_trading_system Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrLightSeaGreen
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "simple_trading_system Buy"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint   MAShift=4;
//---   
input uint   MAPeriod=2;
input  ENUM_MA_METHOD   MAType=MODE_EMA;
input ENUM_APPLIED_PRICE   MAPrice=PRICE_CLOSE;
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[];
double BuyBuffer[];
//---      
int MA_Handle,ATR_Handle;
//---      
int min_rates_total;
//---   
int Count[],MAShift_,SumPeriod;
double Ma[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//---
   int numb,Max1,Max2;
   static int count=1;
//---
   Max2=Size;
   Max1=Max2-1;
//---
   count--;
   if(count<0) count=Max1;
//---
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//---
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   int ATR_Period=15;
   min_rates_total=int(MathMax(ATR_Period,MAPeriod+MAShift));
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---    iMA
   MA_Handle=iMA(NULL,0,MAPeriod,0,MAType,MAPrice);
   if(MA_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//---       
   MAShift_=int(MAShift+1);
   SumPeriod=int(MAPeriod+MAShift);
   ArrayResize(Count,MAShift_);
   ArrayResize(Ma,MAShift_);
//---
   ArrayInitialize(Count,0);
   ArrayInitialize(Ma,0.0);
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,234);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,233);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="simple_trading_system";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(MA_Handle)<rates_total
      || BarsCalculated(ATR_Handle)<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//---    
   int to_copy,limit,bar,sign0;
   double MA[],ATR[],ma0,ma1;
   static int sign1;
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total; //      
      sign1=0;
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+1;
//---       MA[]  ATR[]
   if(CopyBuffer(MA_Handle,0,0,to_copy,MA)<=0) return(RESET);
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//---         
   ArraySetAsSeries(MA,true);
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//---   
   sign0=sign1;
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      Ma[Count[0]]=MA[bar];
      //---
      ma0=MA[bar];
      ma1=Ma[Count[MAShift]];
      //---
      if(sign0<+1 && ma0<=ma1 && close[bar]>=close[bar+MAShift] && close[bar]<=close[bar+SumPeriod] && close[bar]<open[bar])
        {
         BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
         sign0=+1;
        }
      //---
      if(sign0>-1 && ma0>=ma1 && close[bar]<=close[bar+MAShift] && close[bar]>=close[bar+SumPeriod] && close[bar]>open[bar])
        {
         SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
         sign0=-1;
        }
      //---
      if(bar)
        {
         Recount_ArrayZeroPos(Count,MAShift_);
         sign1=sign0;
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
