//+------------------------------------------------------------------+
//|                                        Negative_Volume_Index.mq5 |
//|                             Copyright  2011,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2011, Nikolay Kositsin"
//---    
#property link "farria@mail.redcom.ru"
#property description "   (Negative Volume Index - NVI)"
//---   
#property version   "1.01"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 1
//---    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         
#property indicator_color1  clrRed
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  1
#property indicator_width1  1
//---    
#property indicator_label1  "Negative Volume Index"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  //
input int Shift = 0; //       
//+----------------------------------------------+
//---   ,    
//      
double NVIBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//---    PVIBuffer   
   SetIndexBuffer(0,NVIBuffer,INDICATOR_DATA);
//---    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       1  1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,1);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"Negative Volume Index");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<2) return(0);
//---    
   int first,bar;
   long Vol0,Vol1;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=1; //      
      NVIBuffer[0]=1.0;
     }
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total; bar++)
     {
      if(VolumeType==VOLUME_TICK)
       {
        Vol0=long(tick_volume[bar]);
        Vol1=long(tick_volume[bar-1]);
       }
      else
       {
        Vol0=long(volume[bar]);
        Vol1=long(volume[bar-1]);
       }
      
      if(Vol0 < Vol1) NVIBuffer[bar] = NVIBuffer[bar-1] * (1 + ((close[bar] - close[bar-1]) / close[bar-1]));
      else NVIBuffer[bar] = NVIBuffer[bar-1];
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
