//+----------------------------------------------------------------------------+
//|                                                                  Zalog.mq5 |
//|                                                  Copyright 2014, papaklass |
//|                                  https://login.mql5.com/ru/users/papaklass |
//+----------------------------------------------------------------------------+
#property library
#property copyright "Copyright 2014, papaklass"
#property link      "https://login.mql5.com/ru/users/papaklass"
#property version   "1.00"
//+------------------------------------------------------------------+
//|      ,                     |
//|    1                                   |
//+------------------------------------------------------------------+
double GetMarginForOpening(int dir,string sym)
  {
//---     
   long leverage=AccountInfoInteger(ACCOUNT_LEVERAGE);
//---     
   double contract=SymbolInfoDouble(sym,SYMBOL_TRADE_CONTRACT_SIZE);
//---   
   string accCurrency=AccountInfoString(ACCOUNT_CURRENCY);
//---   
   string marginCurrency=StringSubstr(sym,0,3);
//---   
   string profitCurrency=StringSubstr(sym,3,3);
//---   
   string calcCurrency="";
//---   
   string pref=GetSymbolPrefix(sym);
//---   - true,  - false
   double prc=0.0;
   double ask,bid;
   bool isBuy=dir==ORDER_TYPE_BUY;
//---    
   if(profitCurrency==accCurrency) // XXXUSD - 
     {
      calcCurrency=sym;

      if(!SymbolInfoDouble(calcCurrency,SYMBOL_ASK,ask) || 
         !SymbolInfoDouble(calcCurrency,SYMBOL_BID,bid))
         return (-1);
      //---      
      prc=isBuy ? ask: bid;
     }

   if(marginCurrency==accCurrency) // USDXXX -  
     {
      calcCurrency=sym;
      prc=1.0;
     }

   if(calcCurrency=="")
     {
      //---     
      double crossPrice=isBuy ? ask: bid;

      calcCurrency=GetSymbolByCurrencies(profitCurrency,accCurrency,pref);

      if(!SymbolInfoDouble(calcCurrency,SYMBOL_ASK,ask) || 
         !SymbolInfoDouble(calcCurrency,SYMBOL_BID,bid))
         return (-1);

      prc=isBuy ? crossPrice*ask: crossPrice*bid;

      if(calcCurrency=="NULL")
        {
         calcCurrency=GetSymbolByCurrencies(accCurrency,profitCurrency,pref);

         if(!SymbolInfoDouble(calcCurrency,SYMBOL_ASK,ask) || 
            !SymbolInfoDouble(calcCurrency,SYMBOL_BID,bid))
            return (-1);

         prc=isBuy ? crossPrice/ask: crossPrice/bid;
        }
     }
//---
   if(leverage!=0 && prc!=0 && contract!=0)
      return (NormalizeDouble(prc * contract / leverage, 2));
//---
   return (-1);
  }
//+------------------------------------------------------------------+
//|                                |
//|  (base)   (profit)                               |
//+------------------------------------------------------------------+
string GetSymbolByCurrencies(string baseCurrency,
                             string accCurrency,
                             string pref="")
  {
//---   
   string calcCurrency=""+baseCurrency+accCurrency;
//---
   if(pref!="")
      calcCurrency=""+baseCurrency+accCurrency+pref;
//---
   if(SymbolInfoDouble(calcCurrency,SYMBOL_ASK)!=0)
      return (calcCurrency);
//---
   return ("NULL");
  }
//+------------------------------------------------------------------+
//|                                                 |
//+------------------------------------------------------------------+
string GetSymbolPrefix(string sym)
  {
   string pref="";
//---
   if(StringLen(sym)>6)
      pref=StringSubstr(sym,6,StringLen(sym)-1);
//---
   return (pref);
  }
//+------------------------------------------------------------------+
