//+------------------------------------------------------------------+
//|                                                Combinatorics.mqh |
//|                                           Copyright 2012, denkir |
//|                           https://login.mql5.com/ru/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, denkir"
#property link      "https://login.mql5.com/ru/users/denkir"
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                          Factorial                               |
//+------------------------------------------------------------------+
double factorial(int x)
  {
   return !x ? 1 : x*factorial(x-1);
  }
//+------------------------------------------------------------------+
//|                          Combination                             |
//+------------------------------------------------------------------+
/*
  Combinations - is a omnifarious combinations which can be formed from N elements by k elements in group. The elements in group differ only by the elements. 
  In the combinations the order of elements is ignored.
  
                  N!   
   C(k,N) =   ----------
               k!*(N-k)! 

*/
double combination(int N,int k)
  {
   int nCombs;
   nCombs=factorial(N)/(factorial(k)*factorial(N-k));
   return nCombs;
  }
//+------------------------------------------------------------------+
//|                      Combination with repetition                 |
//+------------------------------------------------------------------+
/*
  In combinations with repetitions the elements can be repeated inside a group.
  
               (N+k-1)!   
   ~C(k,N) = ---------------
               k!*(N-1)! 

*/
double _combination(int N,int k)
  {
   int _nCombs;
   _nCombs=factorial(N+k-1)/(factorial(k)*factorial(N-1));
   return _nCombs;
  }  
  
//+------------------------------------------------------------------+
//|                         Accommodation                            |
//+------------------------------------------------------------------+
/*
  Accommodation - is a omnifarious combinations which can be formed from N elements by k elements in group, and elements in group differ by the elements or the order of elements 
                 N!   
   A(k,N) =  ----------
               (N-k)!
             
*/
double arrangement(int N,int k) 
  {
   double nArm;
   nArm=factorial(N)/factorial(N-k);
   return nArm;
  }
//+------------------------------------------------------------------+
//|                  Accommodation with repetition                   |
//+------------------------------------------------------------------+
/*
  Accommodation with repetition from N elements by k - is a ordered k-elements samples, in which the elements can be repeated.
            
   ~A(k,N) = N^k
     
*/
double _arrangement(int N,int k) 
  {
   double _nArm;
   _nArm=pow(N,k);
   return _nArm;
  }
//+------------------------------------------------------------------+
//|                          Permutation                             |
//+------------------------------------------------------------------+
/*
  Permutation from N elements  - is a accommodation from N elements by N (Permutation - is a special case of accommodation)
                 
   P(N) =  N!
             
*/
double permutation(int N)
  {
   return factorial(N);
  }
//+------------------------------------------------------------------+
//|                  Permutation with repetition                     |
//+------------------------------------------------------------------+
/*
  Permutations with repetitions from N elements  - is a permutations by k distinct elements, where 
  the elements can be repeated m1, m2, , mk times and m1 + m2 + + mk = n, where n - total number of elements
                 
                                    n!
   ~P(n)(m1, m2, , mk) = ----------------------------
                             m1! * m2! *  *mk!
             
*/
double _permutation(int &nM[])
/*
  nM - array, which stores the number of repetitions of each element (m1, m2, , mk)

*/
  {
   double _permutations=NULL;
   int len=ArraySize(nM);
   int sum=0;
   for(int i=0;i<len;i++)
      sum+=nM[i];

   double m_factorials[]; // factorials of all 'm' values 
   double sum_fac;        // factorial of sum
   sum_fac=factorial(sum);
   ArrayResize(m_factorials,len);

   for(int i=0;i<len;i++) // calculation factorials of all 'm' values 
     {
      m_factorials[i]=factorial(nM[i]);
      sum_fac/=m_factorials[i];
     }
   _permutations=sum_fac;
   return _permutations;
  }
//+------------------------------------------------------------------+
