//+------------------------------------------------------------------+ 
//|                                                     BoDi_HTF.mq5 | 
//|                               Copyright  2014, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2014, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---   
#property version   "1.60"
//---     
#property indicator_separate_window 
//---    2
#property indicator_buffers 2 
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//---      
#property indicator_color1 clrDeepPink,clrGray,clrDodgerBlue
//---   - 
#property indicator_style1 STYLE_SOLID
//---     5
#property indicator_width1 5
//---   
#property indicator_label1 "BoDi HTF"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input ENUM_TIMEFRAMES     TimeFrame=PERIOD_H4;         //  
input uint                BBPeriod=20;                 //     
input double              StdDeviation=2;              // - 
input ENUM_APPLIED_PRICE  applied_price=PRICE_CLOSE;   //  
input bool                ReDraw=true;                 //      
//+-----------------------------------+
//---      
int min_rates_total;
//---      
int BoDi_Handle;
//---   ,    
//---      
double BoDiBuffer[],ColorBoDiBuffer[];
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| BoDi indicator initialization function                           | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=3;
//---     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    BoDi       ");
      return(INIT_FAILED);
     }
//---    BoDi
   BoDi_Handle=iCustom(Symbol(),TimeFrame,"BoDi",BBPeriod,StdDeviation,applied_price);
   if(BoDi_Handle==INVALID_HANDLE)
     {
      Print("      BoDi");
      return(INIT_FAILED);
     }
//---    BoDiBuffer   
   SetIndexBuffer(0,BoDiBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(BoDiBuffer,true);
//---     ,     
   SetIndexBuffer(1,ColorBoDiBuffer,INDICATOR_COLOR_INDEX);
//---       
   ArraySetAsSeries(ColorBoDiBuffer,true);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---      
   string shortname;
   StringConcatenate(shortname,"BoDi HTF( ",GetStringTimeframe(TimeFrame)," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| BoDi iteration function                                          | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(BoDi_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---   
   int limit,bar;
//---       
   double BoDi[1],Col[1];
   datetime BoDiTime[1];
   static uint LastCountBar;
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       
//---       
   ArraySetAsSeries(time,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      BoDiBuffer[bar]=EMPTY_VALUE;
      ColorBoDiBuffer[bar]=1;
      //---      
      if(CopyTime(Symbol(),TimeFrame,time[bar],1,BoDiTime)<=0) return(RESET);
      //---
      if(time[bar]>=BoDiTime[0] && time[bar+1]<BoDiTime[0])
        {
         LastCountBar=bar;
         //---      
         if(CopyBuffer(BoDi_Handle,0,time[bar],1,BoDi)<=0) return(RESET);
         if(CopyBuffer(BoDi_Handle,1,time[bar],1,Col)<=0) return(RESET);
         //---      
         BoDiBuffer[bar]=BoDi[0];
         ColorBoDiBuffer[bar]=Col[0];
        }
      //---
      if(ReDraw)
        {
         if(BoDiBuffer[bar+1]!=EMPTY_VALUE && BoDiBuffer[bar]==EMPTY_VALUE)
           {
            BoDiBuffer[bar]=BoDiBuffer[bar+1];
            ColorBoDiBuffer[bar]=ColorBoDiBuffer[bar+1];
           }
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
