//+------------------------------------------------------------------+
//|                                                  RVIWithFlat.mq5 |
//|                                 Copyright  2014, Powered byStep | 
//|                                                                  | 
//+------------------------------------------------------------------+
#property description "Relative Vigor Index With Flat"
//----  
#property copyright "Copyright  2014, Powered byStep"
//----  
#property link      ""
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 3
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|     1            |
//+----------------------------------------------+
//---      
#property indicator_type1   DRAW_FILLING
//---     
#property indicator_color1  clrTeal,clrMagenta
//----    
#property indicator_label1  "RVI Oscillator"
//+----------------------------------------------+
//|     2            |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----         
#property indicator_color2  clrBlue
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  5
#property indicator_width2  5
//----    
#property indicator_label2  "Flat"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1  0.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint                BBPeriod=20;                 //    
input double              StdDeviation=2.0;            //  
input ENUM_APPLIED_PRICE  applied_price=PRICE_CLOSE;   //   
input uint                RVIPeriod=14;                //  RVI
input uint                flat=100;                    //    
input int                 Shift=0;                     //       
//+----------------------------------------------+
//----   ,    
//      
double IndBuffer[];
double SignalBuffer[];
double IndBuffer1[];
//----      
int BB_Handle,RVI_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_total=int(MathMax(BBPeriod,RVIPeriod));

//----    iBands
   BB_Handle=iBands(Symbol(),PERIOD_CURRENT,BBPeriod,0,StdDeviation,applied_price);
   if(BB_Handle==INVALID_HANDLE)
     {
      Print("      iBands");
      return(INIT_FAILED);
     }
//----    iRVI
   RVI_Handle=iRVI(Symbol(),PERIOD_CURRENT,RVIPeriod);
   if(RVI_Handle==INVALID_HANDLE)
     {
      Print("      iRVI");
      return(INIT_FAILED);
     }

//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(IndBuffer,true);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   SetIndexBuffer(1,SignalBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(SignalBuffer,true);
   
//----      
   SetIndexBuffer(2,IndBuffer1,INDICATOR_DATA);
//----       
   ArraySetAsSeries(IndBuffer1,true);
//----    1    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   IndicatorSetString(INDICATOR_SHORTNAME,"RVIWithFlat");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,4);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(BarsCalculated(BB_Handle)<rates_total || BarsCalculated(RVI_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----    
   int to_copy,limit,bar;
   double MainRVI[],SignRVI[],UpBB[],MainBB[];

//----         limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+1;

//----      
   if(CopyBuffer(BB_Handle,UPPER_BAND,0,to_copy,UpBB)<=0) return(RESET);
   if(CopyBuffer(BB_Handle,BASE_LINE,0,to_copy,MainBB)<=0) return(RESET);
   if(CopyBuffer(RVI_Handle,MAIN_LINE,0,to_copy,MainRVI)<=0) return(RESET);
   if(CopyBuffer(RVI_Handle,SIGNAL_LINE,0,to_copy,SignRVI)<=0) return(RESET);

//----         
   ArraySetAsSeries(UpBB,true);
   ArraySetAsSeries(MainBB,true);
   ArraySetAsSeries(MainRVI,true);
   ArraySetAsSeries(SignRVI,true);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      double res=(UpBB[bar]-MainBB[bar])/_Point;
      if(res<flat)
        {
         if(MainRVI[bar]>SignRVI[bar])
           {
            IndBuffer[bar]=0.000000001;
            SignalBuffer[bar]=0.000000001;
            IndBuffer1[bar]=0;
           }
           
         if(MainRVI[bar]<SignRVI[bar])
           {
            IndBuffer[bar]=0.000000001;
            SignalBuffer[bar]=0.000000001;
            IndBuffer1[bar]=0;
           }
        }
      else
        {
         IndBuffer1[bar]=EMPTY_VALUE;
         IndBuffer[bar]=MainRVI[bar];
         SignalBuffer[bar]=SignRVI[bar];
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
