//+------------------------------------------------------------------+
//|                                              TradeStatistics.mq5 |
//|                                                        avoitenko |
//|                        https://login.mql5.com/en/users/avoitenko |
//+------------------------------------------------------------------+
#property copyright "avoitenko"
#property link      "https://login.mql5.com/en/users/avoitenko"
#property version   "1.00"

#property script_show_inputs

#include <CTradeStatistics.mqh>

//+------------------------------------------------------------------+
//|   Input Parameters                                               |
//+------------------------------------------------------------------+
input bool     InpUseAllHistory     =  true;                // Use all history
input datetime InpTimeStart         =  D'2011.10.03 00:00'; // Time begin
input datetime InpTimeEnd           =  D'2011.12.31 00:00'; // Time end

CTradeStatistics m_stat;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   if(InpUseAllHistory)
     {
      if(m_stat.Calculate()) m_stat.PrintStatistics();
      else Print(m_stat.GetLastErrorString());
     }
   else
     {
      if(m_stat.Calculate(InpTimeStart,InpTimeEnd)) m_stat.PrintStatistics();
      else Print(m_stat.GetLastErrorString());
     }
  }
//+------------------------------------------------------------------+
