//+------------------------------------------------------------------+
//|                                     WriteOptimizationResults.mq5 |
//|            Copyright 2013, https://login.mql5.com/ru/users/tol64 |
//|                                  Site, http://tol64.blogspot.com |
//+------------------------------------------------------------------+
#property copyright   "Copyright 2013, http://tol64.blogspot.com"
#property link        "http://tol64.blogspot.com"
#property description "email: hello.tol64@gmail.com"
#property version     "1.0"
//--- Name of the Expert Advisor
#define EXPERT_NAME MQL5InfoString(MQL5_PROGRAM_NAME)
//--- Common folder of all client terminals
#define COMMONDATA_PATH TerminalInfoString(TERMINAL_COMMONDATA_PATH)
//--- Number of values for writing to the file
#define STAT_VALUES_COUNT 7
//--- Load the class
#include <Trade/Trade.mqh>
//--- Load the class
CTrade              trade;
//--- The latest data
MqlTick             last_tick;
//--- Structure of the trade request result
MqlTradeResult      trade_result;
//--- Trade request structure
MqlTradeRequest     trade_request;
//--- Structure of the trade request check results
MqlTradeCheckResult trade_check_result;
//--- Include custom libraries
#include "Include/Enums.mqh"
#include "Include/Errors.mqh"
#include "Include/TradeSignals.mqh"
#include "Include/TradeFunctions.mqh"
#include "Include/FileFunctions.mqh"
#include "Include/Auxiliary.mqh"
//--- External parameters of the Expert Advisor
input  int              NumberOfBars           = 2;              // Number of one-direction bars
sinput double           Lot                    = 0.1;            // Lot
input  double           TakeProfit             = 100;            // Take Profit
input  double           StopLoss               = 50;             // Stop Loss
input  double           TrailingStop           = 10;             // Trailing Stop
input  bool             Reverse                = true;           // Position reversal
sinput string           delimeter=""; // --------------------------------
sinput bool             LogOptimizationReport  = true;           // Writing results to a file
sinput CRITERION_RULE   CriterionSelectionRule = RULE_AND;       // Condition for writing
sinput ENUM_STATS       Criterion_01           = C_NO_CRITERION; // 01 - Criterion name
sinput double           CriterionValue_01      = 0;              // ---- Criterion value
sinput ENUM_STATS       Criterion_02           = C_NO_CRITERION; // 02 - Criterion name
sinput double           CriterionValue_02      = 0;              // ---- Criterion value
sinput ENUM_STATS       Criterion_03           = C_NO_CRITERION; // 03 - Criterion name
sinput double           CriterionValue_03      = 0;              // ---- Criterion value
//--- Global variables
int    AllowedNumberOfBars=0;       // For checking the NumberOfBars external parameter value
string OptimizationResultsPath="";  // Location of the folder for saving folders and files
int    UsedCriteriaCount=0;         // Number of used criteria
int    OptimizationFileHandle=-1;   // Handle of the file of optimization results
//---
double close_price[]; // Close (closing price of the bar)
double open_price[];  // Open (opening price of the bar)
double high_price[];  // High (High price of the bar)
double low_price[];   // Low (Low price of the bar)
//---
int    criteria[3];                    // Criteria for optimization report generation
double criteria_values[3];             // Values of criteria
double stat_values[STAT_VALUES_COUNT]; // Array for testing parameters
//+------------------------------------------------------------------+
//| Initialization                                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- Initialize the new bar
   CheckNewBar();
//--- Initialization completed successfully
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Deinitialization                                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//--- Print the deinitialization reason to the journal
   Print(GetDeinitReasonText(reason));
//--- Display the amount of memory used (approximate value)
   Print("TERMINAL_MEMORY_USED: ",TerminalInfoInteger(TERMINAL_MEMORY_USED)," Mb");
  }
//+------------------------------------------------------------------+
//| Current symbol tick event                                        |
//+------------------------------------------------------------------+
void OnTick()
  {
//--- If the bar is not new, exit
   if(!CheckNewBar())
      return;
//--- If there is a new bar
   else
     {
      GetBarsData();        // Get bar data
      TradingBlock();       // Check the conditions and trade
      ModifyTrailingStop(); // Modify the Trailing Stop level
     }
  }
//+------------------------------------------------------------------+
//| Optimization start                                               |
//+------------------------------------------------------------------+
void OnTesterInit()
  {
   Print(__FUNCTION__,"(): Start Optimization \n-----------");
  }
//+------------------------------------------------------------------+
//| Test completion event handler                                    |
//+------------------------------------------------------------------+
double OnTester()
  {
//--- If writing of optimization results is enabled
   if(LogOptimizationReport)
     {
      //--- Fill the array with test values
      GetTestStatistics(stat_values);
      //--- Create a frame
      FrameAdd("Statistics",1,0,stat_values);
     }
//---
   return(0.0);
  }
//+------------------------------------------------------------------+
//| Next optimization pass                                           |
//+------------------------------------------------------------------+
void OnTesterPass()
  {
//--- If writing of optimization results is enabled
   if(LogOptimizationReport)
      CreateOptimizationReport();
  }
//+------------------------------------------------------------------+
//| End of optimization                                              |
//+------------------------------------------------------------------+
void OnTesterDeinit()
  {
   Print("-----------\n",__FUNCTION__,"(): End Optimization");
//--- If writing of optimization results is enabled
   if(LogOptimizationReport)
     {
      //--- Close the file of optimization results
      FileClose(OptimizationFileHandle);
     }
  }
//+------------------------------------------------------------------+
