//+------------------------------------------------------------------+
//|                                                     TeachHNN.mqh |
//|                                Copyright () 2012-2013, Hlaimann |
//|                                           http://www.hlaiman.com |
//+------------------------------------------------------------------+
#include <Expert\Signal\SignalHNN.mqh>
#property copyright "Copyright 2013, Hlaimann."
#property link      "http://www.hlaiman.com"
#property version   "1.00"
#property script_show_inputs

#define SIGNAL_BUY        1
#define SIGNAL_SELL      -1
#define BUY_ST           "buy"
#define SELL_ST          "sell"
#define SYMBOL_ARROWUP   241
#define SYMBOL_ARROWDOWN 242
//+------------------------------------------------------------------+
//| Inputs                                                           |
//+------------------------------------------------------------------+
input string   Expert_Title     = "SampleHNN";  // Document name
input int      NetLayersCount   = 3;            // Neural layers
input int      NetNeuronsCount  = 60;           // Middle neurons
input int      NetEpochCount    = 10000;        // Teaching epochs
input int      NetPatternBars   = 12;           // Pattern bars
input bool     NetTeachSignals  = true;         // Teaching a net?
input string   SignalsOption    = "<- Signals auto creation block ->";
input bool     SignalsCreate    = true;
input int      SignalsBarsCount = 1;
input int      SignalsBarPoints = 50;
input datetime SignalsStartTime = D'2010.01.01 00:00';
input datetime SignalsEndTime   = 0;
input bool     SignalsClear     = true;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   int BuyPatterns,SellPatterns,LastArrow=0,obj_total=ObjectsTotal(0);
   bool AutoArrow=false;
   if(obj_total<=0)
     {
      printf(__FUNCTION__+": error, orders arrow not found!");
      if(!SignalsCreate) return;
      if(!SymbolIsSynchronized(_Symbol)) return;
      if(AutoSignals()<=0)
         printf(__FUNCTION__+": error, orders arrow not created!");
      else
        {
         obj_total=ObjectsTotal(0);
         if(obj_total>0)
           {
            AutoArrow=true;
            printf("Signals total "+IntegerToString(obj_total));
           }
        }
     }
   if(NetTeachSignals)
     {
      CSignalHNN *SignalHNN=new CSignalHNN;
      if(SignalHNN==NULL)
        {
         printf(__FUNCTION__+": error creating CSignalHNN");
         return;
        }
      SignalHNN.PatternBarsCount(NetPatternBars);
      SignalHNN.LayersCount(NetLayersCount);
      SignalHNN.NeuronsCount(NetNeuronsCount);
      SignalHNN.EpochCount(NetEpochCount);
      if(!SignalHNN.InitHNN(false))
        {
         delete SignalHNN;
         printf(__FUNCTION__+": error to initialize CSignalHNN");
         return;
        }
      BuyPatterns=0;
      SellPatterns=0;
      for(int i=0; i<obj_total; i++)
        {
         string onum="",oname=ObjectName(0,i);
         long typ= ObjectGetInteger(0,oname,OBJPROP_TYPE);
         if(typ != OBJ_ARROW_UP && typ != OBJ_ARROW_DOWN &&
            typ!=OBJ_ARROW_BUY && typ!=OBJ_ARROW_SELL) continue;
         long tim=ObjectGetInteger(0,oname,OBJPROP_TIME);
         Print("Arrow Detected at time ",TimeToString(tim));
         if(SignalHNN.FillPattern(tim)!=true) Print("Aborted - Invalid pattern!");
         else
           {
            if(typ==OBJ_ARROW_BUY || typ==OBJ_ARROW_SELL)
              {
               ObjectSetInteger(0,oname,OBJPROP_SELECTABLE,true);
               int ic=0;
               while(StringGetCharacter(oname,ic)!='#' && ic<StringLen(oname)) ic++;
               if(ic<StringLen(oname) && StringGetCharacter(oname,ic)=='#')
                 {
                  for(int ii=ic+1; ii<StringLen(oname); ii++)
                    {
                     ushort ch=StringGetCharacter(oname,ii);
                     if(ch>='0' && ch<='9') onum=onum+CharToString((uchar)ch); else break;
                    }
                  if(StringLen(onum)>0)
                    {
                     long anum=StringToInteger(onum);
                     if(LastArrow==0 || (LastArrow+1)!=anum)
                       {
                        LastArrow=int(anum);
                        if(StringFind(oname,SELL_ST)>0)
                          {
                           if(SignalHNN.AddPattern(ObjectName(0,i),SIGNAL_SELL))
                             {
                              SellPatterns++;
                              Print("Sell signal detected at pattern #",SellPatterns);
                             }
                           else Print("Error to add sell signal pattern #",SellPatterns);
                             } else if(StringFind(oname,BUY_ST)>0) {
                           if(SignalHNN.AddPattern(ObjectName(0,i),SIGNAL_BUY))
                             {
                              BuyPatterns++;
                              Print("Buy signal detected at pattern #",BuyPatterns);
                             }
                           else Print("Error to add buy signal pattern #",BuyPatterns);
                          }
                       }
                     else LastArrow=0;
                    }
                  else Print("Error to read trading signal!=> "+oname);
                 }
                 } else if(ObjectGetInteger(0,oname,OBJPROP_ARROWCODE)==SYMBOL_ARROWDOWN) {
               // arrow down - sell
               if(SignalHNN.AddPattern(ObjectName(0,i),SIGNAL_SELL))
                 {
                  SellPatterns++;
                  Print("Sell signal detected at pattern #",SellPatterns);
                 }
                 } else if(ObjectGetInteger(0,oname,OBJPROP_ARROWCODE)==SYMBOL_ARROWUP) {
               // arrow up - buy
               if(SignalHNN.AddPattern(ObjectName(0,i),SIGNAL_BUY))
                 {
                  BuyPatterns++;
                  Print("Buy signal detected at pattern #",BuyPatterns);
                 }
              }
           }
        }
      if(BuyPatterns+SellPatterns>0 && SignalHNN.TeachHNN() && SignalHNN.SaveFileHNN())
         Print("Neural net create success! On ",BuyPatterns+SellPatterns," patterns");
      else Print("Neural net create error! On ",BuyPatterns+SellPatterns," patterns");
      delete SignalHNN;
     }
   if(SignalsClear && AutoArrow)
     {
      ObjectsDeleteAll(0,0,OBJ_ARROW_UP);
      ObjectsDeleteAll(0,0,OBJ_ARROW_DOWN);
     }
//---

  }
//+------------------------------------------------------------------+
//| AutoSignals                                                      |
//+------------------------------------------------------------------+
int AutoSignals()
  {
   int i,ibars,pips,minpips,Counter1,Counter2;
   datetime Last;
   long digs;
   string name="",Prefix="arrow";
   double Close[],High[],Low[],Open[];
   datetime stim,etim,Time[];

   digs=SymbolInfoInteger(Symbol(),SYMBOL_DIGITS);
   if(digs==3 || digs==5) minpips=SignalsBarPoints*10;
   else minpips=SignalsBarPoints;

   int bars= Bars(_Symbol, PERIOD_CURRENT);
   if(bars<=0)
     {
      printf(__FUNCTION__+": error, bars not found!");
      return(-1);
     }

   if(!ArraySetAsSeries(Open,true) || !ArraySetAsSeries(High,true) || 
      !ArraySetAsSeries(Low,true) || !ArraySetAsSeries(Close,true) || 
      !ArraySetAsSeries(Time,true) || 
      CopyOpen(_Symbol,PERIOD_CURRENT,0,bars,Open)<bars || 
      CopyHigh(_Symbol,PERIOD_CURRENT,0,bars,High)<bars || 
      CopyLow(_Symbol,PERIOD_CURRENT,0,bars,Low)<bars || 
      CopyTime(_Symbol,PERIOD_CURRENT,0,bars,Time)<bars || 
      CopyClose(_Symbol,PERIOD_CURRENT,0,bars,Close)<bars)
     {
      printf(__FUNCTION__+": error to init data!");
      return(-1);
     }

   if(SignalsStartTime<=0) stim=Time[bars-1];
   else stim=SignalsStartTime;
   if(SignalsEndTime<=0) etim=Time[0]; else etim=SignalsEndTime;
   if(SignalsBarsCount<=0 || SignalsBarPoints<=0 || etim<=stim)
     {
      printf(__FUNCTION__+": error, invalid parameters!");
      return(-1);
     }

   Counter1=0; Counter2=0; Last=0; i=0;
   while(Time[i]>etim && i<bars) i++;
   while(i<bars)
     {
      ibars= 0;
      pips = 0;
      while(ibars<SignalsBarsCount && MathAbs(pips)<minpips)
        {
         pips+=int((Open[i+ibars]-Close[i+ibars])/Point());
         ibars++;
        }
      if(MathAbs(pips)>=minpips)
        {
         Last = Time[i + ibars];
         name = Prefix + string(Counter1 + Counter2);
         if(pips<=-minpips)
           {
            Counter1++;
            ObjectCreate(0,name,OBJ_ARROW_UP,0,Last,Low[i+ibars]);
            ObjectSetInteger(0,name,OBJPROP_ARROWCODE,SYMBOL_ARROWUP);
            ObjectSetInteger(0,name,OBJPROP_COLOR,Blue);
            ObjectSetInteger(0,name,OBJPROP_SELECTABLE,true);
              } else {
            Counter2++;
            ObjectCreate(0,name,OBJ_ARROW_DOWN,0,Last,High[i+ibars]);
            ObjectSetInteger(0,name,OBJPROP_ARROWCODE,SYMBOL_ARROWDOWN);
            ObjectSetInteger(0,name,OBJPROP_COLOR,Red);
            ObjectSetInteger(0,name,OBJPROP_SELECTABLE,true);
           }
         i+=ibars;
        }
      else i++;
      if(i>=(bars-SignalsBarsCount) || Time[i]<=stim || Time[i]==0) break;
     }
   printf(__FUNCTION__+" Profit = ",SignalsBarPoints," pips in ",
          SignalsBarsCount," bars, arrows upBUY = ",Counter1," dnSELL = ",Counter2);
   return(Counter1+Counter2);
  }
//+------------------------------------------------------------------+
