//+------------------------------------------------------------------+
//|                                                 ScraperBot06.mq4 |
//|                                  Copyright 2019, Steven A. Brown |
//|                         https://www.mql5.com/en/users/SteveBrown |
//|                                                                  |
//| This script implements ScraperBot05 using WinINet instead of     |
//| WebRequest, which was found to be unreliable on the MT4 platform |
//+------------------------------------------------------------------+

#import "wininet.dll"
int InternetCheckConnectionW(string &lpszUrl,uint dwFlags,uint dwReserved);
int InternetOpenW(string &lpszAgent,uint dwAccessType,string &lpszProxyName,string &lpszProxyBypass,uint dwFlags);
int InternetOpenUrlW(int hInternetSession,string &lpszUrl,string &lpszHeaders,uint dwHeadersLength,uint dwFlags,uint dwContext);
int InternetConnectW(int hInternet,string &lpszServerName,int nServerPort,string &lpszUsername,string &lpszPassword,uint dwService,uint dwFlags,uint dwContext);
int HttpOpenRequestW(int hConnect,string &lpszVerb,string &lpszObjectName,string &lpszVersion,string &lpszReferer,string &lplpszAcceptTypes,uint dwFlags,uint dwContext);
int HttpSendRequestW(int hRequest,string &lpszHeaders,uint dwHeadersLength,uchar &lpOptional[],uint dwOptionalLength);
int InternetReadFile(int hFile,uchar &lpBuffer[],uint dwNumberOfBytesToRead,uint &lpdwNumberOfBytesRead);
int InternetCloseHandle(int hInternet);
#import

uchar uc_Buffer[16400];             // InternetReadFile() expects a static buffer.
float f_US, f_DE, f_FR, f_IT, f_EU; // global variables to store bond yields
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnStart()
  {
   bool bResult;  int i,iNet1,iNet2;
   string stURL="http://www.msn.com";

   bResult=InternetCheckConnectionW(stURL,1,0); // 1 == FLAG_ICC_FORCE_CONNECTION
   Print("InternetCheckConnectionW() returned ",bResult);
   if(!bResult) return;

   string stAgent="Mozilla/5.0",stNull="";
   iNet1 = InternetOpenW(stAgent, // _In_ LPCTSTR lpszAgent 
                         1,       // 1 == INTERNET_OPEN_TYPE_DIRECT
                         stNull,  // _In_ LPCTSTR lpszProxyName
                         stNull,  // _In_ LPCTSTR lpszProxyBypass
                         NULL);   // _In_ DWORD dwFlags
   Print("iNet1 == ",iNet1);
   if(iNet1==0) return;

   stURL="https://api.wsj.net/api/dylan/quotes/v2/comp/quoteByDialect?dialect=official&needed=CompositeTrading|BluegrassChannels&"
         "MaxInstrumentMatches=1&accept=application/json&EntitlementToken=cecc4267a0194af89ca343805a3e57af&ckey=cecc4267a0&"
         "dialects=Charting&id=Bond-BX-TMUBMUSD10Y,Bond-BX-TMBMKDE-10Y,Bond-BX-TMBMKFR-10Y,Bond-BX-TMBMKIT-10Y"; // four ticker symbols

   string stHdr="Accept: text/*";
   iNet2 = InternetOpenUrlW(iNet1,           // HINTERNET hInternet,
                            stURL,           // LPCWSTR   lpszUrl,
                            stHdr,           // LPCWSTR   lpszHeaders,
                            StringLen(stHdr),// DWORD     dwHeadersLength,
                            0x00080000,      // DWORD dwFlags, 0x00080000 == INTERNET_FLAG_NO_COOKIES
                            NULL);           // DWORD_PTR dwContext
   Print("iNet2 == ",iNet2);
   if(iNet2==0)
     {
      InternetCloseHandle(iNet1);
      return;
     }

   uint uGet,uGot;
   uGet=16384; // number of bytes to download
   bResult = InternetReadFile(iNet2,     // _In_  HINTERNET hFile
                              uc_Buffer, // _Out_ LPVOID lpBuffer
                              uGet,      // _In_  DWORD dwNumberOfBytesToRead
                              uGot);     // _Out_ LPDWORD lpdwNumberOfBytesRead
   Print("InternetReadFile() returned ",bResult,". Number of bytes read: ",uGot);
   InternetCloseHandle(iNet2);  // download done
   if(!bResult) {InternetCloseHandle(iNet1); return;}
   uc_Buffer[uGot]=0;  // Terminate string in uc_Buffer by appending a null character.

   string stSearch="\"CompositeTrading\":{\"Last\":{\"Price\":{\"Iso\":\"PERCENT\",\"Value\":";

// Get US 10-year treasury note yield.
   i=StringFind(CharArrayToString(uc_Buffer),"\"Ticker\":\"TMUBMUSD10Y\"",0); // 0 == position from which search starts 
   if(i==-1) {Print("\"Ticker\":\"TMUBMUSD10Y\" not found."); InternetCloseHandle(iNet1); return;}
   i=StringFind(CharArrayToString(uc_Buffer),stSearch,i); // i == position from which search starts 
   Print("Offset of ",stSearch," == ",i);
   if(i==-1) {Print(stSearch," not found."); InternetCloseHandle(iNet1); return;}
   i+=61; // Advance index to known location of text representing bond yield.
   f_US=StringToDouble(StringSubstr(CharArrayToString(uc_Buffer),i,8));
   Print("US 10-year T-note yield, stored in variable f_US: ",f_US);

// Get German 10-year government bond yield.
   i=StringFind(CharArrayToString(uc_Buffer),"\"Ticker\":\"TMBMKDE-10Y\"",i); // i == position from which search starts 
   if(i==-1) {Print("\"Ticker\":\"TMBMKDE-10Y\" not found."); InternetCloseHandle(iNet1); return;}
   i=StringFind(CharArrayToString(uc_Buffer),stSearch,i); // i == position from which search starts 
   Print("Offset of ",stSearch," == ",i);
   if(i==-1) {Print(stSearch," not found."); InternetCloseHandle(iNet1); return;}
   i+=61; // Advance index to known location of text representing bond yield.
   f_DE=StringToDouble(StringSubstr(CharArrayToString(uc_Buffer),i,8));
   Print("German 10-year government bond yield, stored in variable f_DE: ",f_DE);

// Get French 10-year government bond yield.
   i=StringFind(CharArrayToString(uc_Buffer),"\"Ticker\":\"TMBMKFR-10Y\"",i); // i == position from which search starts 
   if(i==-1) {Print("\"Ticker\":\"TMBMKFR-10Y\" not found."); InternetCloseHandle(iNet1); return;}
   i=StringFind(CharArrayToString(uc_Buffer),stSearch,i); // i == position from which search starts 
   Print("Offset of ",stSearch," == ",i);
   if(i==-1) {Print(stSearch," not found."); InternetCloseHandle(iNet1); return;}
   i+=61; // Advance index to known location of text representing bond yield.
   f_FR=StringToDouble(StringSubstr(CharArrayToString(uc_Buffer),i,8));
   Print("French 10-year government bond yield, stored in variable f_FR: ",f_FR);

// Get Italian 10-year government bond yield.
   i=StringFind(CharArrayToString(uc_Buffer),"\"Ticker\":\"TMBMKIT-10Y\"",i); // i == position from which search starts 
   if(i==-1) {Print("\"Ticker\":\"TMBMKIT-10Y\" not found."); InternetCloseHandle(iNet1); return;}
   i=StringFind(CharArrayToString(uc_Buffer),stSearch,i); // i == position from which search starts 
   Print("Offset of ",stSearch," == ",i);
   if(i==-1) {Print(stSearch," not found."); InternetCloseHandle(iNet1); return;}
   i+=61; // Advance index to known location of text representing bond yield.
   f_IT=StringToDouble(StringSubstr(CharArrayToString(uc_Buffer),i,8));
   Print("Italian 10-year government bond yield, stored in variable f_IT: ",f_IT);

// Calculate European composite bond yield.
   f_EU=0.449*f_DE+0.315*f_FR+0.236*f_IT;
   Print("European composite bond yield: ",f_EU);

// Calculate interest rate differential.
   Print("Interest rate differential, f_EU-f_US = ",f_EU-f_US);
   InternetCloseHandle(iNet1); // Done with wininet.
  }//END void OnStart()
//+------------------------------------------------------------------+
