//+------------------------------------------------------------------+
//|                                                 ScraperBot05.mq5 |
//|                                  Copyright 2019, Steven A. Brown |
//|                         https://www.mql5.com/en/users/SteveBrown |
//+------------------------------------------------------------------+

char ch_Buffer[], ch_Data[16];      // global buffers
float f_US, f_DE, f_FR, f_IT, f_EU; // global variables to store bond yields
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnStart()
  {
   int i;
   string stURL="https://api.wsj.net/api/dylan/quotes/v2/comp/quoteByDialect?dialect=official&needed=CompositeTrading|BluegrassChannels&"
                "MaxInstrumentMatches=1&accept=application/json&EntitlementToken=cecc4267a0194af89ca343805a3e57af&ckey=cecc4267a0&"
                "dialects=Charting&id=Bond-BX-TMUBMUSD10Y,Bond-BX-TMBMKDE-10Y,Bond-BX-TMBMKFR-10Y,Bond-BX-TMBMKIT-10Y"; // four ticker symbols

   string stHdr="Accept: text/*, User-Agent: Mozilla/5.0";
   string stRspHdr; // response header

   i = WebRequest("GET",     // const string  method,    HTTP method 
                  stURL,     // const string  url,       URL 
                  stHdr,     // const string  headers,  
                  1024,      // int           timeout, 
                  ch_Data,   // const char    &data[],   the array of the HTTP message body 
                  ch_Buffer, // char          &result[], an array containing server response data 
                  stRspHdr); // string        &result_headers 

   Print("Server response code: ",i);
   if(i==-1) {Print("GetLastError == ",GetLastError());  return;}
   Print("Size of ch_Buffer (bytes downloaded) == ",ArraySize(ch_Buffer));
//Print("Response header:\n", stRspHdr);   
   string stSearch="\"CompositeTrading\":{\"Last\":{\"Price\":{\"Iso\":\"PERCENT\",\"Value\":";

// Get US 10-year treasury note yield.
   i=StringFind(CharArrayToString(ch_Buffer),"\"Ticker\":\"TMUBMUSD10Y\"",0); // 0 == position from which search starts 
   if(i==-1) {Print("\"Ticker\":\"TMUBMUSD10Y\" not found.");  return;}
   i=StringFind(CharArrayToString(ch_Buffer),stSearch,i); // i == position from which search starts 
   Print("Offset of ",stSearch," == ",i);
   if(i==-1) {Print(stSearch," not found.");  return;}
   i+=61; // Advance index to known location of text representing bond yield.
   f_US=StringToDouble(StringSubstr(CharArrayToString(ch_Buffer),i,8));
   Print("US 10-year T-note yield, stored in variable f_US: ",f_US);

// Get German 10-year government bond yield.
   i=StringFind(CharArrayToString(ch_Buffer),"\"Ticker\":\"TMBMKDE-10Y\"",i); // i == position from which search starts 
   if(i==-1) {Print("\"Ticker\":\"TMBMKDE-10Y\" not found.");  return;}
   i=StringFind(CharArrayToString(ch_Buffer),stSearch,i); // i == position from which search starts 
   Print("Offset of ",stSearch," == ",i);
   if(i==-1) {Print(stSearch," not found.");  return;}
   i+=61; // Advance index to known location of text representing bond yield.
   f_DE=StringToDouble(StringSubstr(CharArrayToString(ch_Buffer),i,8));
   Print("German 10-year government bond yield, stored in variable f_DE: ",f_DE);

// Get French 10-year government bond yield.
   i=StringFind(CharArrayToString(ch_Buffer),"\"Ticker\":\"TMBMKFR-10Y\"",i); // i == position from which search starts 
   if(i==-1) {Print("\"Ticker\":\"TMBMKFR-10Y\" not found.");  return;}
   i=StringFind(CharArrayToString(ch_Buffer),stSearch,i); // i == position from which search starts 
   Print("Offset of ",stSearch," == ",i);
   if(i==-1) {Print(stSearch," not found.");  return;}
   i+=61; // Advance index to known location of text representing bond yield.
   f_FR=StringToDouble(StringSubstr(CharArrayToString(ch_Buffer),i,8));
   Print("French 10-year government bond yield, stored in variable f_FR: ",f_FR);

// Get Italian 10-year government bond yield.
   i=StringFind(CharArrayToString(ch_Buffer),"\"Ticker\":\"TMBMKIT-10Y\"",i); // i == position from which search starts 
   if(i==-1) {Print("\"Ticker\":\"TMBMKIT-10Y\" not found.");  return;}
   i=StringFind(CharArrayToString(ch_Buffer),stSearch,i); // i == position from which search starts 
   Print("Offset of ",stSearch," == ",i);
   if(i==-1) {Print(stSearch," not found.");  return;}
   i+=61; // Advance index to known location of text representing bond yield.
   f_IT=StringToDouble(StringSubstr(CharArrayToString(ch_Buffer),i,8));
   Print("Italian 10-year government bond yield, stored in variable f_IT: ",f_IT);

// Calculate European composite bond yield.
   f_EU=0.449*f_DE+0.315*f_FR+0.236*f_IT;
   Print("European composite bond yield: ",f_EU);

// Calculate interest rate differential.
   Print("Interest rate differential, f_EU-f_US = ",f_EU-f_US);
  }//END void OnStart()
//+------------------------------------------------------------------+
