//+------------------------------------------------------------------+
//|                                                 ScraperBot04.mq5 |
//|                                  Copyright 2019, Steven A. Brown |
//|                         https://www.mql5.com/en/users/SteveBrown |
//+------------------------------------------------------------------+

char ch_Buffer[],ch_Data[16];
float f_US;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnStart()
  {
   int i;
   string stURL="https://api.wsj.net/api/dylan/quotes/v2/comp/quoteByDialect?dialect=official&needed=CompositeTrading|BluegrassChannels&"
                "MaxInstrumentMatches=1&accept=application/json&EntitlementToken=cecc4267a0194af89ca343805a3e57af&ckey=cecc4267a0&"
                "dialects=Charting&id=Bond-BX-TMUBMUSD10Y"; // US
//               "dialects=Charting&id=Bond-BX-TMBMKDE-10Y"; // DE
//               "dialects=Charting&id=Bond-BX-TMBMKFR-10Y"; // FR
//               "dialects=Charting&id=Bond-BX-TMBMKIT-10y"; // IT

   string stHdr="Accept: text/*, User-Agent: Mozilla/5.0";
   string stRspHdr; // response header

   i = WebRequest("GET",     // const string  method,    HTTP method 
                  stURL,     // const string  url,       URL 
                  stHdr,     // const string  headers,  
                  1024,      // int           timeout, 
                  ch_Data,   // const char    &data[],   the array of the HTTP message body 
                  ch_Buffer, // char          &result[], an array containing server response data 
                  stRspHdr); // string        &result_headers 

   Print("Server response code: ",i);
   if(i==-1) {Print("GetLastError == ",GetLastError());  return;}
   Print("Size of ch_Buffer (bytes downloaded) == ",ArraySize(ch_Buffer));
   Print("Response header:\n",stRspHdr);

   string stSearch="\"CompositeTrading\":{\"Last\":{\"Price\":{\"Iso\":\"PERCENT\",\"Value\":";
   i=StringFind(CharArrayToString(ch_Buffer),stSearch,0); // 0 == position from which search starts 
   Print("Offset of ",stSearch," == ",i);
   if(i==-1) {Print(stSearch," not found.");  return;}
   i+=61; // Advance index to known location of text representing bond yield.
   f_US=StringToDouble(StringSubstr(CharArrayToString(ch_Buffer),i,8));
   Print("US 10-year T-note yield, stored in variable f_US: ",f_US);
  }//END void OnStart()
//+------------------------------------------------------------------+
