//+------------------------------------------------------------------+
//|                                                 ScraperBot02.mq5 |
//|                                  Copyright 2019, Steven A. Brown |
//|                         https://www.mql5.com/en/users/SteveBrown |
//+------------------------------------------------------------------+

#import "wininet.dll"
int InternetCheckConnectionW(string &lpszUrl,uint dwFlags,uint dwReserved);
int InternetOpenW(string &lpszAgent,uint dwAccessType,string &lpszProxyName,string &lpszProxyBypass,uint dwFlags);
int InternetOpenUrlW(int hInternetSession,string &lpszUrl,string &lpszHeaders,uint dwHeadersLength,uint dwFlags,uint dwContext);
int InternetConnectW(int hInternet,string &lpszServerName,int nServerPort,string &lpszUsername,string &lpszPassword,uint dwService,uint dwFlags,uint dwContext);
int HttpOpenRequestW(int hConnect,string &lpszVerb,string &lpszObjectName,string &lpszVersion,string &lpszReferer,string &lplpszAcceptTypes,uint dwFlags,uint dwContext);
int HttpSendRequestW(int hRequest,string &lpszHeaders,uint dwHeadersLength,uchar &lpOptional[],uint dwOptionalLength);
int InternetReadFile(int hFile,uchar &lpBuffer[],uint dwNumberOfBytesToRead,uint &lpdwNumberOfBytesRead);
int InternetCloseHandle(int hInternet);
#import

uchar uc_Buffer[16400],uc_DynBuf[];
float f_US;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnStart()
  {
   bool bResult;  int iNet1,iNet2; //, iRequest;  
   string stURL="http://www.msn.com";

   bResult=InternetCheckConnectionW(stURL,1,0); // 1 == FLAG_ICC_FORCE_CONNECTION
   Print("InternetCheckConnectionW() returned ",bResult);
   if(!bResult) return;

   string stAgent="Mozilla/5.0",stNull="";
   iNet1 = InternetOpenW(stAgent, // _In_ LPCTSTR lpszAgent 
                         1,       // 1 == INTERNET_OPEN_TYPE_DIRECT
                         stNull,  // _In_ LPCTSTR lpszProxyName
                         stNull,  // _In_ LPCTSTR lpszProxyBypass
                         NULL);   // _In_ DWORD dwFlags
   Print("iNet1 == ",iNet1);
   if(iNet1==0) return;

   stURL="https://www.marketwatch.com/investing/bond/tmubmusd10y?countrycode=bx";
   string stHdr="Accept: text/*";
   iNet2 = InternetOpenUrlW(iNet1,           // HINTERNET hInternet,
                            stURL,           // LPCWSTR   lpszUrl,
                            stHdr,           // LPCWSTR   lpszHeaders,
                            StringLen(stHdr),// DWORD     dwHeadersLength,
                            0x00080000,      // DWORD dwFlags, 0x00080000 == INTERNET_FLAG_NO_COOKIES
                            NULL);           // DWORD_PTR dwContext
   Print("iNet2 == ",iNet2);
   if(iNet2==0)
     {
      InternetCloseHandle(iNet1);
      return;
     }

   uint uGet,uGot,uDst,uMax;
   uGet = 16384;    // number of bytes to download per call to InternetReadFile, must be at least 1 byte less than size of uc_Buffer
   uGot = uDst = 0; // uGot is number of bytes downloaded in call to InternetReadFile; uDst is total number of bytes downloaded.
   uMax = 180224;   // maximum number of bytes to download.

   do
     {
      bResult = InternetReadFile(iNet2,     // _In_  HINTERNET hFile
                                 uc_Buffer, // _Out_ LPVOID lpBuffer
                                 uGet,      // _In_  DWORD dwNumberOfBytesToRead
                                 uGot);     // _Out_ LPDWORD lpdwNumberOfBytesRead
      //  Print("Bytes read this pass: ", uGot);
      uc_Buffer[uGot]=0; // Terminate string in uc_Buffer by appending a null character.

      ArrayCopy(uc_DynBuf, // destination array 
                uc_Buffer, // source array 
                uDst,      // index at which writing to destination array begins 
                0,         // index at which copying from source array begins 
                uGot);     // number of elements to copy 
      uDst+=uGot; // advance index of destination array for next pass in loop
     }
   while(bResult && uGot>0 && uDst<uMax);

   Print("Size of uc_DynBuf == ",ArraySize(uc_DynBuf));
   Print("Bytes downloaded  == ",uDst);
   Print("InternetReadFile() returned ",bResult,". Number of bytes read in last call: ",uGot);
   InternetCloseHandle(iNet2);  // download done
   if(!bResult) {InternetCloseHandle(iNet1); return;}
// Search for string.  
   int i,j,k; // indexes

   i=StringFind(CharArrayToString(uc_DynBuf),"<script type=\"application/ld+json\">",0); // 0 == position from which search starts 
   Print("Offset of <script type=\"application/ld+json\"> == ",i);
   if(i==-1) {Print("<script type=\"application/ld+json\"> not found.");  InternetCloseHandle(iNet1);  return;}

   j=StringFind(CharArrayToString(uc_DynBuf),"\"price\":\"",i); // i == position from which search starts 
   if(j==-1) {Print("\"price\":\" not found.");  InternetCloseHandle(iNet1);  return;}
   Print("Offset of \"price\":\" == ",j);

   k=StringFind(CharArrayToString(uc_DynBuf),"</script>",i); // i == position from which search starts
   Print("Offset of </script> == ",k);
   if(j>k) {Print("Offset of \"price\":\" is greater than offset of </script>");  InternetCloseHandle(iNet1);  return;}
   j+=9; // Advance index to known location of text representing bond yield.
   f_US=StringToDouble(StringSubstr(CharArrayToString(uc_DynBuf),j,8));
   Print("US 10-year T-note yield, stored in variable f_US: ",f_US);
   InternetCloseHandle(iNet1); // Done with wininet.
  }//END void OnStart()
//+------------------------------------------------------------------+
