//-----------------------------------------------------------------------------------
//                                                                        CBoxCox.mqh
//                                                                      2012, victorg
//                                                                http://www.mql5.com
//-----------------------------------------------------------------------------------
#property copyright "2012, victorg"
#property link      "http://www.mql5.com"

#include "PowellsMethod.mqh"
//-----------------------------------------------------------------------------------
// Class CBoxCox
//-----------------------------------------------------------------------------------
class CBoxCox:public PowellsMethod
  {
protected:
  double Dat[];                                              // Input data
  double BCDat[];                                            // Box-Cox data
  int    Dlen;                                               // Data lenght
  double Par[1];                                             // Parameters
  double LnX;                                                // Summ of ln(x)
public:
  void   CBoxCox(void)       { }
  void   CalcPar(double &dat[]);
  double GetPar(int n)       { return(Par[n]); }
private:
  virtual double func(const double &p[]);
  };
//-----------------------------------------------------------------------------------
// CalcPar
//-----------------------------------------------------------------------------------
void CBoxCox::CalcPar(double &dat[])
  {
  int i;
  double a;
  
  Par[0]=1.0;                                              // initial Lambda
  Dlen=ArraySize(dat);
  ArrayResize(Dat,Dlen);
  ArrayResize(BCDat,Dlen);
  LnX=0;
  for(i=0;i<Dlen;i++)
    {
    a=dat[i]; Dat[i]=a;                                    // Input data
    LnX+=MathLog(a);                                       // Summ of ln(x)
    }
  Optimize(Par);                                           // Powell's optimization
  }
//------------------------------------------------------------------------------------
// func
//------------------------------------------------------------------------------------
double CBoxCox::func(const double &p[])
  {
  int i;
  double a,lamb,var,mean,k,ret;
  
  lamb=p[0]; var=0; mean=0; k=0;
  if (lamb>5.0){k=(lamb-5.0)*400; lamb=5.0;}              // Lambda >  5.0
  else if(lamb<-5.0){k=-(lamb+5.0)*400; lamb=-5.0;}       // Lambda < -5.0
  if(lamb!=0)                                             // Lambda != 0.0
    {
    for(i=0;i<Dlen;i++)
      {
      BCDat[i]=(MathPow(Dat[i],lamb)-1.0)/lamb;           // BC transform
      mean+=BCDat[i]/Dlen;                                // Calculate mean
      }
    }
  else                                                    // Lambda == 0.0
    {
    for(i=0;i<Dlen;i++)
      {
      BCDat[i]=MathLog(Dat[i]);                           // BC transform
      mean+=BCDat[i]/Dlen;                                // Calculate mean
      }
    }
  for(i=0;i<Dlen;i++)
    {
    a=BCDat[i]-mean;
    var+=a*a/Dlen;                                        // Variance
    }
  ret=Dlen*MathLog(var)/2.0-(lamb-1)*LnX;                 // Log-likelihood
  return(k+ret);
  }
//------------------------------------------------------------------------------------
