//+------------------------------------------------------------------+
//|                                                 testDistance.mq5 |
//|                                   2016 MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2016, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_minimum -100
#property indicator_maximum 100

#property indicator_buffers 2
#property indicator_plots   2

input int WPR       = 20; //Period WPR
input int maperiod  = 10; //Period MA
input color   clr   = clrGreen;
input color   clrMA = clrMagenta;


double ind[],ma[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int h,h1;
int OnInit()
  {
//--- indicator buffers mapping
      h = iCustom(NULL,0,"testWPReur",WPR);
      if (h == INVALID_HANDLE) {
         Print("Error while creating testWPReur");
         return (INIT_FAILED);
      }
      h1 = iCustom(NULL,0,"testWPRusd",WPR);
      if (h1 == INVALID_HANDLE) {
         Print("Error while creating testWPRusd");
         return (INIT_FAILED);
      }  
   ArraySetAsSeries(ind,true);
   SetIndexBuffer(0,ind);        
   
   IndicatorSetString(INDICATOR_SHORTNAME,"testWPRdistance");
   IndicatorSetInteger(INDICATOR_DIGITS,2);
   IndicatorSetInteger(INDICATOR_LEVELS,2);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_SOLID);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_SOLID);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrRed);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrRed);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,0,1);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,1,1);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,-60);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,60);

   PlotIndexSetInteger(0,PLOT_DRAW_TYPE,DRAW_LINE);
   PlotIndexSetInteger(0,PLOT_LINE_STYLE,STYLE_SOLID);
   PlotIndexSetInteger(0,PLOT_LINE_WIDTH,2);
   PlotIndexSetInteger(0,PLOT_LINE_COLOR,clr);
   PlotIndexSetString(0,PLOT_LABEL,"_tstWPRdistance_");     
   
   ArraySetAsSeries(ma,true);   
   SetIndexBuffer(1,ma);
   PlotIndexSetInteger(1, PLOT_DRAW_TYPE, DRAW_LINE           ); 
   PlotIndexSetInteger(1, PLOT_LINE_STYLE, STYLE_SOLID            ); 
   PlotIndexSetInteger(1, PLOT_LINE_WIDTH, 1            ); 
   PlotIndexSetInteger(1, PLOT_LINE_COLOR, clrMA            ); 
   PlotIndexSetString (1, PLOT_LABEL, "Middle_Basket_line_MA" );    
//---
   return(INIT_SUCCEEDED);
  }
  
double GetValue(int shift) 
  {
   double dBuf[1], dBuf1[1];
   double res=0.0;
   CopyBuffer(h,0,shift,1,dBuf);
   CopyBuffer(h1,0,shift,1,dBuf1);
   return (NormalizeDouble((dBuf[0] - dBuf1[0])/2, _Digits) );
  }  
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   if(prev_calculated==0 || rates_total>prev_calculated+1) 
     {
      int rt=rates_total-WPR;//-maperiod;
  
      for(int i=1; i<rt; i++) 
        {
         ind[i]= GetValue(i);
        }
      rt -= maperiod;  
      for (int i = 1; i< rt; i++) 
        {
         ma[i] = GetMA(ind, i, maperiod, _Digits);
        }
     }
   else 
     {
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
void OnDeinit(const int reason)
  {
   IndicatorRelease(h);
   IndicatorRelease(h1);
   string text;
   switch(reason)
     {
      case REASON_PROGRAM:
         text="Indicator terminated its operation by calling the ExpertRemove() function";break;
      case REASON_INITFAILED:
         text="This value means that OnInit() handler "+__FILE__+" has returned a nonzero value";break;
      case REASON_CLOSE:
         text="Terminal has been closed"; break;
      case REASON_ACCOUNT:
         text="Account was changed";break;
      case REASON_CHARTCHANGE:
         text="Symbol or timeframe was changed";break;
      case REASON_CHARTCLOSE:
         text="Chart was closed";break;
      case REASON_PARAMETERS:
         text="Input-parameter was changed";break;
      case REASON_RECOMPILE:
         text="Program "+__FILE__+" was recompiled";break;
      case REASON_REMOVE:
         text="Program "+__FILE__+" was removed from chart";break;
      case REASON_TEMPLATE:
         text="New template was applied to chart";break;
      default:text="Another reason";
     }
   PrintFormat("%s",text);
  } 
//+------------------------------------------------------------------+

double GetMA(const double& arr[], int index , int period, int digit) {
   double m = 0;
   for (int j = 0; j < period; j++)  m += arr[index + j];
   m /= period;
   return (NormalizeDouble(m,digit));
}