//+------------------------------------------------------------------+
//|																				 View |
//|                             Copyright 2006-2011, www.FXmaster.de |
//|                                                  www.FXmaster.de |
//+------------------------------------------------------------------+
#property copyright "Copyright 2006-2011, www.FXmaster.de"
#property link      "www.FXmaster.de"
#property version   "1.00"

#include "..\Lib\GraphLib.mqh"

//------------------------------------------------------------------	CView
class CView
{
//--- basic functions
public:
	CView() { }; // constructor
	~CView() { }; // destructor
	virtual void Create(long chart, string name, int wnd, color clr, color bgclr, color selclr, int x, int y, int dx, int dy, int corn=0, int fontsize=8, string font="Arial");

//--- function of processing of state
public:
	virtual int OnClick(string name) { return(0); }; // processing the event of clicking on an object

//--- parameters of displaying
public:
	int m_x, m_y; // coordinates of the upper left corner of the window
	int m_x0, m_y0; // coordinate of the reference point
	int m_dx, m_dy; // window size
	color m_clr, m_bgclr, m_selclr; // color of border, background and selection
	long m_chart; // ID of chart
	int m_wnd; // number of subwindow of the chart
	string m_name; // object name
	int m_corn; // anchor corner
	string m_font; // font name
	int m_fontsize; // font size

//--- functions of displaying
public:
	virtual void Draw() {}; // refresh the object view and its branch objects
	virtual void DeleteView() {}; // delete the object view and its branch objects
	bool IsOpenView();
};
//------------------------------------------------------------------	Create
void CView::Create(long achart, string name, int wnd, color clr, color bgclr, color selclr, int x, int y, int dx, int dy, int corn=0, int fontsize=8, string font="Arial")
{
	m_chart=achart; m_name=name; m_wnd=wnd; 
	m_clr=clr; m_bgclr=bgclr; m_selclr=selclr; 
	m_x=x; m_y=y; m_dx=dx; m_dy=dy; m_corn=corn; 
	m_fontsize=fontsize; m_font=font;
	m_x0=0; m_y0=0; // coordinates of reference point
}
//------------------------------------------------------------------	IsOpenView
bool CView::IsOpenView()
{
	long first=ChartFirst(); long next=ChartNext(first);
	while (first!=next && next>0) { if (m_chart==next) return(true); next=ChartNext(next); }
	return(false);
}
