//+------------------------------------------------------------------+
//|                                                   	 ScrollView |
//|                             Copyright 2006-2011, www.FXmaster.de |
//|                                                  www.FXmaster.de |
//+------------------------------------------------------------------+
#property copyright "Copyright 2006-2011, www.FXmaster.de"
#property link      "www.FXmaster.de"
#property version   "1.00"

#include "View.mqh"

#define SV_VDIR		0
#define SV_HDIR		1

//------------------------------------------------------------------	class CScrollView
class CScrollView: public CView
{
//--- basic functions
public:
	CScrollView() { m_value=0; m_min=0; m_max=100; m_step=1; }
	~CScrollView() { DeleteView(); }
	virtual void Create(long chart, string name, int wnd, color clr, color bgclr, color selclr, int x, int y, int dx, int dy, int corn=0, int fontsize=8);

//--- function of processing of state
public:
	int m_dir; //  
	double m_min, m_max; // maximum/minimum of progress
	double m_value; // current value
	double m_step; // step of progress
	virtual int OnClick(string name); // name of the object that has been clicked

//--- functions of displaying
public:
	virtual void Draw(); // refresh the view
	virtual void DeleteView(); // delete all elements of the view
};

//------------------------------------------------------------------	Create
void CScrollView::Create(long chart, string name, int wnd, color clr, color bgclr, color selclr, int x, int y, int dx, int dy, int corn=0, int fontsize=8)
{
	CView::Create(chart, name,  wnd, clr, bgclr, selclr, x, y, dx, dy, corn, fontsize, "Wingdings");
	if (dx>dy) m_dir=SV_HDIR; else m_dir=SV_VDIR;
	m_min=0; m_max=100; m_value=0; m_step=1;
}
//------------------------------------------------------------------	OnClick
int CScrollView::OnClick(string name)
{
	double s=0;
	if (name==m_name+".up") s=-1; if (name==m_name+".dn") s=1;
	if (s==0) return(0);
	double v=m_value+s*m_step; if (v>m_max || v<m_min) return(0);
	m_value=MathMax(MathMin(v, m_max), m_min);
	Draw(); // drew
	return(int(s));
}
//------------------------------------------------------------------	Draw
void CScrollView::Draw()
{
	double k=1.2;
	if (m_max-m_min==0) return;
	if (m_dir==SV_HDIR) // horizontal
	{
		SetRectLbl(m_chart, m_name, m_wnd, "", m_clr, m_bgclr, m_x+m_dy, m_y-1, m_dx-2*m_dy, m_dy+2, m_corn, m_fontsize, m_font, true);
		SetButton(m_chart, m_name+".up", m_wnd, CharToString(215), m_selclr, m_clr, m_x, m_y, m_dy, m_dy, m_corn, m_fontsize, m_font, false);
		SetButton(m_chart, m_name+".dn", m_wnd, CharToString(216), m_selclr, m_clr, m_x+m_dx-m_dy, m_y, m_dy, m_dy, m_corn, m_fontsize, m_font, false);
		double w=m_dx-2*m_dy-m_dy/k;
		int pos=int(w/(m_max-m_min)*m_value);
		SetRectLbl(m_chart, m_name+".bar", m_wnd, "", m_selclr, m_clr, m_x+m_dy+pos, m_y, int(m_dy/k), m_dy, m_corn, m_fontsize, m_font);
	}
	else //SV_VDIR// vertical
	{
		SetRectLbl(m_chart, m_name, m_wnd, "", m_clr, m_bgclr, m_x-1, m_y+m_dx, m_dx+2, m_dy-2*m_dx, m_corn, m_fontsize, m_font, true);
		SetButton(m_chart, m_name+".up", m_wnd, CharToString(217), m_selclr, m_clr, m_x, m_y, m_dx, m_dx, m_corn, m_fontsize, m_font, false);
		SetButton(m_chart, m_name+".dn", m_wnd, CharToString(218), m_selclr, m_clr, m_x, m_y+m_dy-m_dx, m_dx, m_dx, m_corn, m_fontsize, m_font, false);

		double w=m_dy-2*m_dx-m_dx/k;
		int pos=int(w/(m_max-m_min)*m_value);
		SetRectLbl(m_chart, m_name+".bar", m_wnd, "", m_selclr, m_clr, m_x, m_y+m_dx+pos, m_dx, int(m_dx/k), m_corn, m_fontsize, m_font);
	}
	ChartRedraw(m_chart); // refreshed the chart
}
//------------------------------------------------------------------	Draw
void CScrollView::DeleteView() 
{
	ObjectDelete(m_chart, m_name); ObjectDelete(m_chart, m_name+".bar");
	ObjectDelete(m_chart, m_name+".up"); ObjectDelete(m_chart, m_name+".dn");
}
